/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.messagebus;

import com.google.inject.Inject;
import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.messagebus.NetworkMultiplexerHolder;
import com.yahoo.messagebus.network.Identity;
import com.yahoo.messagebus.network.NetworkMultiplexer;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;

public class NetworkMultiplexerProvider {
    private final NetworkMultiplexer net;

    @Inject
    public NetworkMultiplexerProvider(NetworkMultiplexerHolder net, ContainerMbusConfig mbusConfig, SlobroksConfig slobroksConfig) {
        this(net, mbusConfig, slobroksConfig, System.getProperty("config.id"));
    }

    public NetworkMultiplexerProvider(NetworkMultiplexerHolder net, ContainerMbusConfig mbusConfig, SlobroksConfig slobroksConfig, String identity) {
        this.net = net.get(NetworkMultiplexerProvider.asParameters(mbusConfig, slobroksConfig, identity));
    }

    public static RPCNetworkParams asParameters(ContainerMbusConfig mbusConfig, SlobroksConfig slobroksConfig, String identity) {
        return new RPCNetworkParams().setSlobroksConfig(slobroksConfig).setIdentity(new Identity(identity)).setListenPort(mbusConfig.port()).setNumTargetsPerSpec(mbusConfig.numconnectionspertarget()).setNumNetworkThreads(mbusConfig.numthreads()).setTransportEventsBeforeWakeup(mbusConfig.transport_events_before_wakeup()).setOptimization(RPCNetworkParams.Optimization.valueOf((String)mbusConfig.optimize_for().name()));
    }

    public NetworkMultiplexer net() {
        return this.net;
    }
}

