/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.messagebus;

import com.yahoo.component.ComponentId;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.container.jdisc.messagebus.SessionCache;
import com.yahoo.jdisc.ReferencedResource;
import com.yahoo.jdisc.service.CurrentContainer;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.IntermediateSessionParams;
import com.yahoo.messagebus.jdisc.MbusServer;
import com.yahoo.messagebus.shared.ServerSession;
import com.yahoo.messagebus.shared.SharedIntermediateSession;
import java.util.logging.Logger;

public class MbusServerProvider
implements Provider<MbusServer> {
    private static final Logger log = Logger.getLogger(MbusServerProvider.class.getName());
    private final MbusServer server;
    private final ReferencedResource<SharedIntermediateSession> sessionRef;

    public MbusServerProvider(ComponentId id, SessionCache sessionCache, CurrentContainer currentContainer) {
        ComponentId chainId = id.withoutNamespace();
        this.sessionRef = sessionCache.retainIntermediate(MbusServerProvider.createIntermediateSessionParams(true, chainId.stringValue()));
        this.server = new MbusServer(currentContainer, (ServerSession)this.sessionRef.getResource());
    }

    static IntermediateSessionParams createIntermediateSessionParams(boolean broadcastName, String name) {
        IntermediateSessionParams intermediateParams = new IntermediateSessionParams();
        intermediateParams.setBroadcastName(broadcastName);
        intermediateParams.setName(name);
        return intermediateParams;
    }

    public SharedIntermediateSession getSession() {
        return (SharedIntermediateSession)this.sessionRef.getResource();
    }

    public MbusServer get() {
        return this.server;
    }

    public void deconstruct() {
        log.log(LogLevel.INFO, "Deconstructing mbus server: " + this.server);
        this.server.close();
        this.server.release();
        this.sessionRef.getReference().close();
    }
}

