/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.component;

import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.log.LogLevel;
import com.yahoo.protect.Process;
import java.time.Duration;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Deconstructor
implements ComponentDeconstructor {
    private static final Logger log = Logger.getLogger(Deconstructor.class.getName());
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, ThreadFactoryFactory.getThreadFactory((String)"component-deconstructor"));
    private final Duration delay;

    public Deconstructor(boolean delayDeconstruction) {
        this.delay = delayDeconstruction ? Duration.ofSeconds(60L) : Duration.ZERO;
    }

    public void deconstruct(Object component) {
        if (component instanceof AbstractComponent) {
            AbstractComponent abstractComponent = (AbstractComponent)component;
            if (abstractComponent.isDeconstructable()) {
                this.executor.schedule(new DestructComponentTask(abstractComponent), this.delay.getSeconds(), TimeUnit.SECONDS);
            }
        } else if (component instanceof Provider) {
            log.info("Starting deconstruction of provider " + component);
            ((Provider)component).deconstruct();
            log.info("Finished deconstruction of provider " + component);
        } else if (component instanceof SharedResource) {
            log.info("Releasing container reference to resource " + component);
            ((SharedResource)component).release();
        }
    }

    private static class DestructComponentTask
    implements Runnable {
        private final Random random = new Random(System.nanoTime());
        private final AbstractComponent component;

        DestructComponentTask(AbstractComponent component) {
            this.component = component;
        }

        private Duration getRandomizedShutdownDelay() {
            long seconds = (long)this.random.nextDouble() * 60L * 10L;
            return Duration.ofSeconds(seconds);
        }

        @Override
        public void run() {
            log.info("Starting deconstruction of component " + this.component);
            try {
                this.component.deconstruct();
                log.info("Finished deconstructing of component " + this.component);
            }
            catch (Exception | NoClassDefFoundError e) {
                log.log(Level.WARNING, "Exception thrown when deconstructing component " + this.component, e);
            }
            catch (Error e) {
                try {
                    Duration shutdownDelay = this.getRandomizedShutdownDelay();
                    log.log((Level)LogLevel.FATAL, "Error when deconstructing component " + this.component + ". Will sleep for " + shutdownDelay.getSeconds() + " seconds then restart", e);
                    Thread.sleep(shutdownDelay.toMillis());
                }
                catch (InterruptedException exception) {
                    log.log(Level.WARNING, "Randomized wait before dying disrupted. Dying now.");
                }
                Process.logAndDie((String)("Shutting down due to error when deconstructing component " + this.component));
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Non-error not exception throwable thrown when deconstructing component  " + this.component, e);
            }
        }
    }
}

