/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.athenz.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.container.core.identity.IdentityConfig;
import com.yahoo.container.jdisc.athenz.impl.AthenzCredentials;
import com.yahoo.container.jdisc.athenz.impl.AthenzService;
import com.yahoo.container.jdisc.athenz.impl.CryptoUtils;
import com.yahoo.container.jdisc.athenz.impl.IdentityDocumentService;
import com.yahoo.container.jdisc.athenz.impl.InstanceIdentity;
import com.yahoo.container.jdisc.athenz.impl.InstanceRefreshInformation;
import com.yahoo.container.jdisc.athenz.impl.InstanceRegisterInformation;
import com.yahoo.container.jdisc.athenz.impl.SignedIdentityDocument;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.time.Clock;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

class AthenzCredentialsService {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final IdentityConfig identityConfig;
    private final IdentityDocumentService identityDocumentService;
    private final AthenzService athenzService;
    private final Clock clock;

    AthenzCredentialsService(IdentityConfig identityConfig, IdentityDocumentService identityDocumentService, AthenzService athenzService, Clock clock) {
        this.identityConfig = identityConfig;
        this.identityDocumentService = identityDocumentService;
        this.athenzService = athenzService;
        this.clock = clock;
    }

    AthenzCredentials registerInstance() {
        KeyPair keyPair = CryptoUtils.createKeyPair();
        String rawDocument = this.identityDocumentService.getSignedIdentityDocument();
        SignedIdentityDocument document = AthenzCredentialsService.parseSignedIdentityDocument(rawDocument);
        PKCS10CertificationRequest csr = CryptoUtils.createCSR(this.identityConfig.domain(), this.identityConfig.service(), document.dnsSuffix, document.providerUniqueId, keyPair);
        InstanceRegisterInformation instanceRegisterInformation = new InstanceRegisterInformation(document.providerService, this.identityConfig.domain(), this.identityConfig.service(), rawDocument, CryptoUtils.toPem(csr));
        InstanceIdentity instanceIdentity = this.athenzService.sendInstanceRegisterRequest(instanceRegisterInformation, document.ztsEndpoint);
        return this.toAthenzCredentials(instanceIdentity, keyPair, document);
    }

    AthenzCredentials updateCredentials(AthenzCredentials currentCredentials) {
        SignedIdentityDocument document = currentCredentials.getIdentityDocument();
        KeyPair newKeyPair = CryptoUtils.createKeyPair();
        PKCS10CertificationRequest csr = CryptoUtils.createCSR(this.identityConfig.domain(), this.identityConfig.service(), document.dnsSuffix, document.providerUniqueId, newKeyPair);
        InstanceRefreshInformation refreshInfo = new InstanceRefreshInformation(CryptoUtils.toPem(csr));
        InstanceIdentity instanceIdentity = this.athenzService.sendInstanceRefreshRequest(document.providerService, this.identityConfig.domain(), this.identityConfig.service(), document.providerUniqueId, refreshInfo, document.ztsEndpoint, currentCredentials.getCertificate(), currentCredentials.getKeyPair().getPrivate());
        return this.toAthenzCredentials(instanceIdentity, newKeyPair, document);
    }

    private AthenzCredentials toAthenzCredentials(InstanceIdentity instanceIdentity, KeyPair keyPair, SignedIdentityDocument identityDocument) {
        X509Certificate certificate = instanceIdentity.getX509Certificate();
        String serviceToken = instanceIdentity.getServiceToken();
        return new AthenzCredentials(serviceToken, certificate, keyPair, identityDocument, this.clock.instant());
    }

    private static SignedIdentityDocument parseSignedIdentityDocument(String rawDocument) {
        try {
            return (SignedIdentityDocument)mapper.readValue(rawDocument, SignedIdentityDocument.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

