/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.metric;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.statistics.ActiveContainerMetrics;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Timer;
import java.util.TimerTask;

public class MetricUpdater
extends AbstractComponent {
    @Deprecated
    private static final String DEPRECATED_FREE_MEMORY_BYTES = "freeMemoryBytes";
    @Deprecated
    private static final String DEPRECATED_USED_MEMORY_BYTES = "usedMemoryBytes";
    @Deprecated
    private static final String DEPRECATED_TOTAL_MEMORY_BYTES = "totalMemoryBytes";
    private static final String FREE_MEMORY_BYTES = "mem.heap.free";
    private static final String USED_MEMORY_BYTES = "mem.heap.used";
    private static final String TOTAL_MEMORY_BYTES = "mem.heap.total";
    private static final String MEMORY_MAPPINGS_COUNT = "jdisc.memory_mappings";
    private static final String OPEN_FILE_DESCRIPTORS = "jdisc.open_file_descriptors";
    private final Metric metric;
    private final ActiveContainerMetrics activeContainerMetrics;
    private final Timer timer = new Timer();
    long freeMemory = -1L;
    long totalMemory = -1L;

    @Inject
    public MetricUpdater(Metric metric, ActiveContainerMetrics activeContainerMetrics) {
        this(metric, activeContainerMetrics, 10000L);
    }

    public MetricUpdater(Metric metric, ActiveContainerMetrics activeContainerMetrics, long delayMillis) {
        this.metric = metric;
        this.activeContainerMetrics = activeContainerMetrics;
        this.timer.schedule((TimerTask)new UpdaterTask(), delayMillis, delayMillis);
    }

    public void deconstruct() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    long getFreeMemory() {
        return this.freeMemory;
    }

    long getTotalMemory() {
        return this.totalMemory;
    }

    private class UpdaterTask
    extends TimerTask {
        private UpdaterTask() {
        }

        @Override
        public void run() {
            MetricUpdater.this.freeMemory = Runtime.getRuntime().freeMemory();
            MetricUpdater.this.totalMemory = Runtime.getRuntime().totalMemory();
            long usedMemory = MetricUpdater.this.totalMemory - MetricUpdater.this.freeMemory;
            MetricUpdater.this.metric.set(MetricUpdater.DEPRECATED_FREE_MEMORY_BYTES, (Number)MetricUpdater.this.freeMemory, null);
            MetricUpdater.this.metric.set(MetricUpdater.DEPRECATED_USED_MEMORY_BYTES, (Number)usedMemory, null);
            MetricUpdater.this.metric.set(MetricUpdater.DEPRECATED_TOTAL_MEMORY_BYTES, (Number)MetricUpdater.this.totalMemory, null);
            MetricUpdater.this.metric.set(MetricUpdater.FREE_MEMORY_BYTES, (Number)MetricUpdater.this.freeMemory, null);
            MetricUpdater.this.metric.set(MetricUpdater.USED_MEMORY_BYTES, (Number)usedMemory, null);
            MetricUpdater.this.metric.set(MetricUpdater.TOTAL_MEMORY_BYTES, (Number)MetricUpdater.this.totalMemory, null);
            MetricUpdater.this.metric.set(MetricUpdater.MEMORY_MAPPINGS_COUNT, (Number)this.count_mappings(), null);
            MetricUpdater.this.metric.set(MetricUpdater.OPEN_FILE_DESCRIPTORS, (Number)this.count_open_files(), null);
            MetricUpdater.this.activeContainerMetrics.emitMetrics(MetricUpdater.this.metric);
        }

        private long count_mappings() {
            long count = 0L;
            try {
                byte[] data;
                Path p = Paths.get("/proc/self/maps", new String[0]);
                for (byte b : data = Files.readAllBytes(p)) {
                    if (b != 10) continue;
                    ++count;
                }
            }
            catch (Exception e) {
                System.err.println("Could not read /proc/self/maps: " + e);
            }
            return count;
        }

        private long count_open_files() {
            long count = 0L;
            try {
                Path p = Paths.get("/proc/self/fd", new String[0]);
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(p);){
                    for (Path entry : stream) {
                        ++count;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Could not read /proc/self/fd: " + e);
            }
            return count;
        }
    }
}

