/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.container.handler.threadpool.ContainerThreadPool;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolImpl;
import com.yahoo.container.protect.ProcessTerminator;
import com.yahoo.jdisc.Metric;
import java.util.concurrent.Executor;

public class ThreadPoolProvider
extends AbstractComponent
implements Provider<Executor> {
    private final ContainerThreadPool threadpool;

    @Inject
    public ThreadPoolProvider(ThreadpoolConfig config, Metric metric) {
        this.threadpool = new ContainerThreadpoolImpl(ThreadPoolProvider.translateConfig(config), metric);
    }

    public ThreadPoolProvider(ThreadpoolConfig config, Metric metric, ProcessTerminator processTerminator) {
        this.threadpool = new ContainerThreadpoolImpl(ThreadPoolProvider.translateConfig(config), metric, processTerminator);
    }

    private static ContainerThreadpoolConfig translateConfig(ThreadpoolConfig config) {
        ContainerThreadpoolConfig.Builder builder = new ContainerThreadpoolConfig.Builder().name(config.name()).keepAliveTime(config.keepAliveTime()).maxThreadExecutionTimeSeconds(config.maxThreadExecutionTimeSeconds());
        int max = config.maxthreads();
        int min = config.corePoolSize();
        if (max > 0 && min < 0) {
            min = max;
        } else if (min > 0 && max < 0) {
            max = min;
        }
        if (Math.abs(min) > Math.abs(max)) {
            min = max;
        }
        if (max > 0) {
            builder.maxThreads(max);
        } else {
            builder.relativeMaxThreads(-max);
        }
        if (min > 0) {
            builder.minThreads(min);
        } else {
            builder.relativeMinThreads(-min);
        }
        int queueSize = config.queueSize();
        if (queueSize > 0) {
            builder.queueSize(queueSize);
        } else {
            builder.relativeQueueSize(-queueSize);
        }
        return new ContainerThreadpoolConfig(builder);
    }

    public Executor get() {
        return this.threadpool.executor();
    }

    public void deconstruct() {
        this.threadpool.close();
    }
}

