/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter;

import com.yahoo.jdisc.http.Cookie;
import java.util.concurrent.TimeUnit;

public class JDiscCookieWrapper {
    private Cookie cookie;

    protected JDiscCookieWrapper(Cookie cookie) {
        this.cookie = cookie;
    }

    public static JDiscCookieWrapper wrap(Cookie cookie) {
        return new JDiscCookieWrapper(cookie);
    }

    public String getDomain() {
        return this.cookie.getDomain();
    }

    public int getMaxAge() {
        return this.cookie.getMaxAge(TimeUnit.SECONDS);
    }

    public String getName() {
        return this.cookie.getName();
    }

    public String getPath() {
        return this.cookie.getPath();
    }

    public boolean getSecure() {
        return this.cookie.isSecure();
    }

    public String getValue() {
        return this.cookie.getValue();
    }

    public void setDomain(String pattern) {
        this.cookie.setDomain(pattern);
    }

    public void setMaxAge(int expiry) {
        this.cookie.setMaxAge(expiry, TimeUnit.SECONDS);
    }

    public void setPath(String uri) {
        this.cookie.setPath(uri);
    }

    public void setSecure(boolean flag) {
        this.cookie.setSecure(flag);
    }

    public void setValue(String newValue) {
        this.cookie.setValue(newValue);
    }

    public Cookie getCookie() {
        return this.cookie;
    }
}

