/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.threadpool;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.handler.threadpool.ContainerThreadPool;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.container.handler.threadpool.ExecutorServiceWrapper;
import com.yahoo.container.handler.threadpool.ThreadPoolMetric;
import com.yahoo.container.handler.threadpool.WorkerCompletionTimingThreadPoolExecutor;
import com.yahoo.container.protect.ProcessTerminator;
import com.yahoo.jdisc.Metric;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ContainerThreadpoolImpl
extends AbstractComponent
implements AutoCloseable,
ContainerThreadPool {
    private static final Logger log = Logger.getLogger(ContainerThreadpoolImpl.class.getName());
    private final ExecutorServiceWrapper threadpool;

    @Inject
    public ContainerThreadpoolImpl(ContainerThreadpoolConfig config, Metric metric) {
        this(config, metric, new ProcessTerminator());
    }

    public ContainerThreadpoolImpl(ContainerThreadpoolConfig config, Metric metric, ProcessTerminator processTerminator) {
        this(config, metric, processTerminator, Runtime.getRuntime().availableProcessors());
    }

    ContainerThreadpoolImpl(ContainerThreadpoolConfig config, Metric metric, ProcessTerminator processTerminator, int cpus) {
        boolean hasRelQueueSize;
        boolean hasRelThreads;
        boolean hasAbsThreads = config.minThreads() >= 0 && config.maxThreads() > 0;
        boolean bl = hasRelThreads = config.relativeMinThreads() >= 0.0 && config.relativeMaxThreads() > 0.0;
        if (!hasAbsThreads && !hasRelThreads) {
            throw new IllegalArgumentException("Requires either absolute or relative thread min/max to be configured. " + ContainerThreadpoolImpl.summarizeConfigToString(config, cpus));
        }
        if (hasAbsThreads == hasRelThreads) {
            throw new IllegalArgumentException("Cannot have both absolute and relative min/max configured at the same time. " + ContainerThreadpoolImpl.summarizeConfigToString(config, cpus));
        }
        if (config.minThreads() > config.maxThreads() || config.relativeMinThreads() > config.relativeMaxThreads()) {
            throw new IllegalArgumentException("Min cannot be greater than max. " + ContainerThreadpoolImpl.summarizeConfigToString(config, cpus));
        }
        boolean hasAbsQueueSize = config.queueSize() >= 0;
        boolean bl2 = hasRelQueueSize = config.relativeQueueSize() >= 0.0;
        if (!hasAbsQueueSize && !hasRelQueueSize) {
            throw new IllegalArgumentException("Requires either absolute or relative queueSize to be configured. " + ContainerThreadpoolImpl.summarizeConfigToString(config, cpus));
        }
        if (hasAbsQueueSize == hasRelQueueSize) {
            throw new IllegalArgumentException("Cannot have both absolute and relative configured at the same time. " + ContainerThreadpoolImpl.summarizeConfigToString(config, cpus));
        }
        String name = config.name();
        int maxThreads = ContainerThreadpoolImpl.maxThreads(config, cpus, hasRelThreads);
        int minThreads = ContainerThreadpoolImpl.minThreads(config, cpus, hasRelThreads);
        int queueSize = this.queueSize(config, maxThreads, hasRelQueueSize);
        log.config(String.format("Threadpool '%s': min=%d, max=%d, queue=%s", name, minThreads, maxThreads, this.queueSizeToString(queueSize)));
        ThreadPoolMetric threadPoolMetric = new ThreadPoolMetric(metric, name);
        WorkerCompletionTimingThreadPoolExecutor executor = new WorkerCompletionTimingThreadPoolExecutor(minThreads, maxThreads, (long)config.keepAliveTime() * 1000L, TimeUnit.MILLISECONDS, ContainerThreadpoolImpl.createQueue(queueSize), ThreadFactoryFactory.getThreadFactory((String)name), threadPoolMetric);
        executor.prestartAllCoreThreads();
        this.threadpool = new ExecutorServiceWrapper(executor, threadPoolMetric, processTerminator, (long)config.maxThreadExecutionTimeSeconds() * 1000L, name);
    }

    @Override
    public Executor executor() {
        return this.threadpool;
    }

    @Override
    public void close() {
        this.closeInternal();
    }

    public void deconstruct() {
        this.closeInternal();
        super.deconstruct();
    }

    private void closeInternal() {
        boolean terminated;
        this.threadpool.shutdown();
        try {
            terminated = this.threadpool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (!terminated) {
            this.threadpool.shutdownNow();
        }
    }

    private static BlockingQueue<Runnable> createQueue(int size) {
        if (size == Integer.MAX_VALUE) {
            return new LinkedBlockingQueue<Runnable>();
        }
        return size == 0 ? new SynchronousQueue(false) : new ArrayBlockingQueue(size);
    }

    private static int maxThreads(ContainerThreadpoolConfig config, int cpus, boolean relative) {
        if (relative) {
            return (int)Math.round(config.relativeMaxThreads() * (double)cpus);
        }
        return config.maxThreads();
    }

    private static int minThreads(ContainerThreadpoolConfig config, int cpus, boolean relative) {
        if (relative) {
            return (int)Math.round(config.relativeMinThreads() * (double)cpus);
        }
        return config.minThreads();
    }

    private int queueSize(ContainerThreadpoolConfig config, int maxThreads, boolean relative) {
        if (relative) {
            return (int)Math.round(config.relativeQueueSize() * (double)maxThreads);
        }
        return config.queueSize();
    }

    private static String summarizeConfigToString(ContainerThreadpoolConfig c, int cpus) {
        return String.format("abs[min=%d,max=%d,queue=%d] rel[min=%.3f,max=%.3f,queue=%.3f] cpus=%d", c.minThreads(), c.maxThreads(), c.queueSize(), c.relativeMinThreads(), c.relativeMaxThreads(), c.relativeQueueSize(), cpus);
    }

    private String queueSizeToString(int queueSize) {
        if (queueSize == Integer.MAX_VALUE) {
            return "unlimited";
        }
        return Integer.toString(queueSize);
    }
}

