/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.threadpool;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class ContainerThreadpoolConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "c0b1347ca3773e8d26d613aba5f40143";
    public static final String CONFIG_DEF_NAME = "container-threadpool";
    public static final String CONFIG_DEF_NAMESPACE = "container.handler.threadpool";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.handler.threadpool", "maxThreads int default=-1", "minThreads int default=-1", "relativeMinThreads double default=-1.0", "relativeMaxThreads double default=-1.0", "keepAliveTime double default=5.0", "queueSize int default=-1", "relativeQueueSize double default=-1.0", "maxThreadExecutionTimeSeconds int default=190", "name string default=\"default-pool\""};
    private final IntegerNode maxThreads;
    private final IntegerNode minThreads;
    private final DoubleNode relativeMinThreads;
    private final DoubleNode relativeMaxThreads;
    private final DoubleNode keepAliveTime;
    private final IntegerNode queueSize;
    private final DoubleNode relativeQueueSize;
    private final IntegerNode maxThreadExecutionTimeSeconds;
    private final StringNode name;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public ContainerThreadpoolConfig(Builder builder) {
        this(builder, true);
    }

    private ContainerThreadpoolConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for container-threadpool must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.maxThreads = builder.maxThreads == null ? new IntegerNode(-1) : new IntegerNode(builder.maxThreads.intValue());
        this.minThreads = builder.minThreads == null ? new IntegerNode(-1) : new IntegerNode(builder.minThreads.intValue());
        this.relativeMinThreads = builder.relativeMinThreads == null ? new DoubleNode(-1.0) : new DoubleNode(builder.relativeMinThreads.doubleValue());
        this.relativeMaxThreads = builder.relativeMaxThreads == null ? new DoubleNode(-1.0) : new DoubleNode(builder.relativeMaxThreads.doubleValue());
        this.keepAliveTime = builder.keepAliveTime == null ? new DoubleNode(5.0) : new DoubleNode(builder.keepAliveTime.doubleValue());
        this.queueSize = builder.queueSize == null ? new IntegerNode(-1) : new IntegerNode(builder.queueSize.intValue());
        this.relativeQueueSize = builder.relativeQueueSize == null ? new DoubleNode(-1.0) : new DoubleNode(builder.relativeQueueSize.doubleValue());
        this.maxThreadExecutionTimeSeconds = builder.maxThreadExecutionTimeSeconds == null ? new IntegerNode(190) : new IntegerNode(builder.maxThreadExecutionTimeSeconds.intValue());
        this.name = builder.name == null ? new StringNode("default-pool") : new StringNode(builder.name);
    }

    public int maxThreads() {
        return this.maxThreads.value();
    }

    public int minThreads() {
        return this.minThreads.value();
    }

    public double relativeMinThreads() {
        return this.relativeMinThreads.value();
    }

    public double relativeMaxThreads() {
        return this.relativeMaxThreads.value();
    }

    public double keepAliveTime() {
        return this.keepAliveTime.value();
    }

    public int queueSize() {
        return this.queueSize.value();
    }

    public double relativeQueueSize() {
        return this.relativeQueueSize.value();
    }

    public int maxThreadExecutionTimeSeconds() {
        return this.maxThreadExecutionTimeSeconds.value();
    }

    public String name() {
        return this.name.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ContainerThreadpoolConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer maxThreads = null;
        private Integer minThreads = null;
        private Double relativeMinThreads = null;
        private Double relativeMaxThreads = null;
        private Double keepAliveTime = null;
        private Integer queueSize = null;
        private Double relativeQueueSize = null;
        private Integer maxThreadExecutionTimeSeconds = null;
        private String name = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ContainerThreadpoolConfig config) {
            this.maxThreads(config.maxThreads());
            this.minThreads(config.minThreads());
            this.relativeMinThreads(config.relativeMinThreads());
            this.relativeMaxThreads(config.relativeMaxThreads());
            this.keepAliveTime(config.keepAliveTime());
            this.queueSize(config.queueSize());
            this.relativeQueueSize(config.relativeQueueSize());
            this.maxThreadExecutionTimeSeconds(config.maxThreadExecutionTimeSeconds());
            this.name(config.name());
        }

        private Builder override(Builder __superior) {
            if (__superior.maxThreads != null) {
                this.maxThreads(__superior.maxThreads);
            }
            if (__superior.minThreads != null) {
                this.minThreads(__superior.minThreads);
            }
            if (__superior.relativeMinThreads != null) {
                this.relativeMinThreads(__superior.relativeMinThreads);
            }
            if (__superior.relativeMaxThreads != null) {
                this.relativeMaxThreads(__superior.relativeMaxThreads);
            }
            if (__superior.keepAliveTime != null) {
                this.keepAliveTime(__superior.keepAliveTime);
            }
            if (__superior.queueSize != null) {
                this.queueSize(__superior.queueSize);
            }
            if (__superior.relativeQueueSize != null) {
                this.relativeQueueSize(__superior.relativeQueueSize);
            }
            if (__superior.maxThreadExecutionTimeSeconds != null) {
                this.maxThreadExecutionTimeSeconds(__superior.maxThreadExecutionTimeSeconds);
            }
            if (__superior.name != null) {
                this.name(__superior.name);
            }
            return this;
        }

        public Builder maxThreads(int __value) {
            this.maxThreads = __value;
            return this;
        }

        private Builder maxThreads(String __value) {
            return this.maxThreads(Integer.valueOf(__value));
        }

        public Builder minThreads(int __value) {
            this.minThreads = __value;
            return this;
        }

        private Builder minThreads(String __value) {
            return this.minThreads(Integer.valueOf(__value));
        }

        public Builder relativeMinThreads(double __value) {
            this.relativeMinThreads = __value;
            return this;
        }

        private Builder relativeMinThreads(String __value) {
            return this.relativeMinThreads(Double.valueOf(__value));
        }

        public Builder relativeMaxThreads(double __value) {
            this.relativeMaxThreads = __value;
            return this;
        }

        private Builder relativeMaxThreads(String __value) {
            return this.relativeMaxThreads(Double.valueOf(__value));
        }

        public Builder keepAliveTime(double __value) {
            this.keepAliveTime = __value;
            return this;
        }

        private Builder keepAliveTime(String __value) {
            return this.keepAliveTime(Double.valueOf(__value));
        }

        public Builder queueSize(int __value) {
            this.queueSize = __value;
            return this;
        }

        private Builder queueSize(String __value) {
            return this.queueSize(Integer.valueOf(__value));
        }

        public Builder relativeQueueSize(double __value) {
            this.relativeQueueSize = __value;
            return this;
        }

        private Builder relativeQueueSize(String __value) {
            return this.relativeQueueSize(Double.valueOf(__value));
        }

        public Builder maxThreadExecutionTimeSeconds(int __value) {
            this.maxThreadExecutionTimeSeconds = __value;
            return this;
        }

        private Builder maxThreadExecutionTimeSeconds(String __value) {
            return this.maxThreadExecutionTimeSeconds(Integer.valueOf(__value));
        }

        public Builder name(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.name = __value;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ContainerThreadpoolConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ContainerThreadpoolConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ContainerThreadpoolConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ContainerThreadpoolConfig build() {
            return new ContainerThreadpoolConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

