/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.ssl.impl;

import com.yahoo.jdisc.http.SslProvider;
import com.yahoo.jdisc.http.ssl.impl.SslContextFactoryUtils;
import java.security.KeyStore;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class DefaultConnectorSsl
implements SslProvider.ConnectorSsl {
    private SSLContext sslContext;
    private SslProvider.ConnectorSsl.ClientAuth clientAuth;
    private List<String> cipherSuites = List.of();
    private List<String> protocolVersions = List.of();
    private KeyStore keystore;
    private char[] keystorePassword;
    private KeyStore truststore;
    private char[] truststorePassword;

    @Override
    public SslProvider.ConnectorSsl setSslContext(SSLContext ctx) {
        this.sslContext = ctx;
        return this;
    }

    @Override
    public SslProvider.ConnectorSsl setClientAuth(SslProvider.ConnectorSsl.ClientAuth auth) {
        this.clientAuth = auth;
        return this;
    }

    @Override
    public SslProvider.ConnectorSsl setEnabledCipherSuites(List<String> ciphers) {
        this.cipherSuites = ciphers;
        return this;
    }

    @Override
    public SslProvider.ConnectorSsl setEnabledProtocolVersions(List<String> versions) {
        this.protocolVersions = versions;
        return this;
    }

    @Override
    public SslProvider.ConnectorSsl setKeystore(KeyStore keystore, char[] password) {
        this.keystore = keystore;
        this.keystorePassword = password;
        return this;
    }

    @Override
    public SslProvider.ConnectorSsl setKeystore(KeyStore keystore) {
        this.keystore = keystore;
        return this;
    }

    @Override
    public SslProvider.ConnectorSsl setTruststore(KeyStore truststore, char[] password) {
        this.truststore = truststore;
        this.truststorePassword = password;
        return this;
    }

    @Override
    public SslProvider.ConnectorSsl setTruststore(KeyStore truststore) {
        this.truststore = truststore;
        return this;
    }

    public SslContextFactory.Server createSslContextFactory() {
        SslContextFactory.Server ssl = new SslContextFactory.Server();
        if (this.sslContext != null) {
            ssl.setSslContext(this.sslContext);
        }
        if (this.keystore != null) {
            ssl.setKeyStore(this.keystore);
        }
        if (this.keystorePassword != null) {
            ssl.setKeyStorePassword(new String(this.keystorePassword));
        }
        if (this.truststore != null) {
            ssl.setTrustStore(this.truststore);
        }
        if (this.truststorePassword != null) {
            ssl.setTrustStorePassword(new String(this.truststorePassword));
        }
        switch (this.clientAuth) {
            case DISABLED: {
                ssl.setWantClientAuth(false);
                ssl.setNeedClientAuth(false);
                break;
            }
            case NEED: {
                ssl.setWantClientAuth(false);
                ssl.setNeedClientAuth(true);
                break;
            }
            case WANT: {
                ssl.setWantClientAuth(true);
                ssl.setNeedClientAuth(false);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.clientAuth.name());
            }
        }
        if (!this.cipherSuites.isEmpty()) {
            SslContextFactoryUtils.setEnabledCipherSuites((SslContextFactory)ssl, this.sslContext, this.cipherSuites);
        }
        if (!this.protocolVersions.isEmpty()) {
            SslContextFactoryUtils.setEnabledProtocols((SslContextFactory)ssl, this.sslContext, this.protocolVersions);
        }
        return ssl;
    }
}

