/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.componentgraph.core;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.BindingAnnotation;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.yahoo.collections.Pair;
import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.ConfigInstance;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.container.di.componentgraph.core.ComponentNode;
import com.yahoo.container.di.componentgraph.core.ComponentRegistryNode;
import com.yahoo.container.di.componentgraph.core.Exceptions;
import com.yahoo.container.di.componentgraph.core.GuiceNode;
import com.yahoo.container.di.componentgraph.core.Keys;
import com.yahoo.container.di.componentgraph.core.Node;
import com.yahoo.container.di.componentgraph.cycle.CycleFinder;
import com.yahoo.container.di.componentgraph.cycle.Graph;
import com.yahoo.vespa.config.ConfigKey;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ComponentGraph {
    private static final Logger log = Logger.getLogger(ComponentGraph.class.getName());
    private final long generation;
    private final Map<ComponentId, Node> nodesById = new HashMap<ComponentId, Node>();

    public ComponentGraph(long generation) {
        this.generation = generation;
    }

    public ComponentGraph() {
        this(0L);
    }

    public long generation() {
        return this.generation;
    }

    public int size() {
        return this.nodesById.size();
    }

    public Collection<Node> nodes() {
        return this.nodesById.values();
    }

    public void add(Node component) {
        if (this.nodesById.containsKey(component.componentId())) {
            throw new IllegalStateException("Multiple components with the same id " + String.valueOf(component.componentId()));
        }
        this.nodesById.put(component.componentId(), component);
    }

    private Optional<Node> lookupGlobalComponent(Key<?> key) {
        if (!(key.getTypeLiteral().getType() instanceof Class)) {
            throw new RuntimeException("Type not supported " + String.valueOf(key.getTypeLiteral()));
        }
        Class clazz = key.getTypeLiteral().getRawType();
        Collection<ComponentNode> components = ComponentGraph.matchingComponentNodes(this.nodes(), key);
        if (components.isEmpty()) {
            return Optional.empty();
        }
        if (components.size() == 1) {
            return Optional.ofNullable((Node)Iterables.get(components, (int)0));
        }
        List<ComponentNode> nonProviderComponents = components.stream().filter(c -> !Provider.class.isAssignableFrom(c.instanceType())).toList();
        if (nonProviderComponents.isEmpty()) {
            throw new IllegalStateException("Multiple global component providers for class '" + clazz.getName() + "' found :" + String.valueOf(components));
        }
        if (nonProviderComponents.size() == 1) {
            return Optional.of((Node)nonProviderComponents.get(0));
        }
        throw new IllegalStateException("Multiple global components with class '" + clazz.getName() + "' found : " + String.valueOf(nonProviderComponents));
    }

    public <T> T getInstance(Class<T> clazz) {
        return this.getInstance(Key.get(clazz));
    }

    public <T> T getInstance(Key<T> key) {
        Object ob = this.lookupGlobalComponent(key).map(Node::component).orElseThrow(() -> new IllegalStateException(String.format("No global component with key '%s'  ", key)));
        return (T)ob;
    }

    private Collection<ComponentNode> componentNodes() {
        return ComponentGraph.nodesOfType(this.nodes(), ComponentNode.class);
    }

    private Collection<ComponentRegistryNode> componentRegistryNodes() {
        return ComponentGraph.nodesOfType(this.nodes(), ComponentRegistryNode.class);
    }

    private Collection<ComponentNode> osgiComponentsOfClass(Class<?> clazz) {
        return this.componentNodes().stream().filter(node -> clazz.isAssignableFrom(node.componentType())).toList();
    }

    public List<Node> complete(Injector fallbackInjector) {
        this.componentNodes().forEach(node -> this.completeNode((ComponentNode)node, fallbackInjector));
        this.componentRegistryNodes().forEach(this::completeComponentRegistryNode);
        return ComponentGraph.topologicalSort(this.nodes());
    }

    public List<Node> complete() {
        return this.complete(Guice.createInjector((Module[])new Module[0]));
    }

    public Set<ConfigKey<? extends ConfigInstance>> configKeys() {
        return this.nodes().stream().flatMap(node -> node.configKeys().stream()).collect(Collectors.toSet());
    }

    public void setAvailableConfigs(Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configs) {
        this.componentNodes().forEach(node -> node.setAvailableConfigs(Keys.invariantCopy(configs)));
    }

    public void reuseNodes(ComponentGraph old) {
        Sets.SetView commonComponentIds = Sets.intersection(this.nodesById.keySet(), old.nodesById.keySet());
        for (ComponentId id : commonComponentIds) {
            if (!this.nodesById.get(id).equals(old.nodesById.get(id))) continue;
            this.nodesById.get((Object)id).instance = old.nodesById.get((Object)id).instance;
        }
        for (Node node : ComponentGraph.topologicalSort(this.nodes())) {
            for (Node usedComponent : node.usedComponents()) {
                if (!usedComponent.instance.isEmpty()) continue;
                node.instance = Optional.empty();
            }
        }
    }

    public List<Object> allConstructedComponentsAndProviders() {
        List<Node> orderedNodes = ComponentGraph.topologicalSort(this.nodes());
        Collections.reverse(orderedNodes);
        return orderedNodes.stream().filter(node -> node.constructedInstance().isPresent()).map(node -> node.constructedInstance().orElseThrow()).collect(Collectors.toList());
    }

    private void completeComponentRegistryNode(ComponentRegistryNode registry) {
        registry.injectAll(this.osgiComponentsOfClass(registry.componentClass()));
    }

    private void completeNode(ComponentNode node, Injector fallbackInjector) {
        try {
            Object[] arguments = node.getAnnotatedConstructorParams().stream().map(param -> this.handleParameter(node, fallbackInjector, (Pair<Type, List<Annotation>>)param)).toArray();
            node.setArguments(arguments);
        }
        catch (Exception e) {
            throw Exceptions.removeStackTrace(new RuntimeException("When resolving dependencies of " + node.idAndType(), e));
        }
    }

    private Object handleParameter(Node node, Injector fallbackInjector, Pair<Type, List<Annotation>> annotatedParameterType) {
        Type parameterType = (Type)annotatedParameterType.getFirst();
        List annotations = (List)annotatedParameterType.getSecond();
        if (parameterType instanceof Class && parameterType.equals(ComponentId.class)) {
            return node.componentId();
        }
        if (parameterType instanceof Class && ConfigInstance.class.isAssignableFrom((Class)parameterType)) {
            return this.handleConfigParameter((ComponentNode)node, (Class)parameterType);
        }
        if (parameterType instanceof ParameterizedType) {
            ParameterizedType registry = (ParameterizedType)parameterType;
            if (((ParameterizedType)parameterType).getRawType().equals(ComponentRegistry.class)) {
                return this.getComponentRegistry(registry.getActualTypeArguments()[0]);
            }
        }
        if (parameterType instanceof Class) {
            return this.handleComponentParameter(node, fallbackInjector, (Class)parameterType, annotations);
        }
        if (parameterType instanceof ParameterizedType) {
            throw new RuntimeException("Injection of parameterized type " + String.valueOf(parameterType) + " is not supported.");
        }
        throw new RuntimeException("Injection of type " + String.valueOf(parameterType) + " is not supported");
    }

    private ComponentRegistryNode newComponentRegistryNode(Class<?> componentClass) {
        ComponentRegistryNode registry = new ComponentRegistryNode(componentClass);
        this.add(registry);
        return registry;
    }

    private ComponentRegistryNode getComponentRegistry(Type componentType) {
        Class componentClass;
        if (componentType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)componentType;
            if (wildcardType.getLowerBounds().length > 0 || wildcardType.getUpperBounds().length > 1) {
                throw new RuntimeException("Can't create ComponentRegistry of unknown wildcard type" + String.valueOf(wildcardType));
            }
            componentClass = (Class)wildcardType.getUpperBounds()[0];
        } else if (componentType instanceof Class) {
            componentClass = (Class)componentType;
        } else {
            if (componentType instanceof TypeVariable) {
                throw new RuntimeException("Can't create ComponentRegistry of unknown type variable " + String.valueOf(componentType));
            }
            throw new RuntimeException("Can't create ComponentRegistry of unknown type " + String.valueOf(componentType));
        }
        for (ComponentRegistryNode node : this.componentRegistryNodes()) {
            if (!node.componentClass().equals(componentType)) continue;
            return node;
        }
        return this.newComponentRegistryNode(componentClass);
    }

    private ConfigKey<ConfigInstance> handleConfigParameter(ComponentNode node, Class<?> clazz) {
        Class<?> castClass = clazz;
        return new ConfigKey(castClass, node.configId());
    }

    private <T> Key<T> getKey(Class<T> clazz, Optional<Annotation> bindingAnnotation) {
        return bindingAnnotation.map(annotation -> Key.get((Class)clazz, (Annotation)annotation)).orElseGet(() -> Key.get((Class)clazz));
    }

    private Optional<GuiceNode> matchingGuiceNode(Key<?> key, Object instance) {
        return ComponentGraph.matchingNodes(this.nodes(), GuiceNode.class, key).stream().filter(node -> node.component() == instance).findFirst();
    }

    private Node lookupOrCreateGlobalComponent(Node node, Injector fallbackInjector, Class<?> clazz, Key<?> key) {
        Optional<Node> component = this.lookupGlobalComponent(key);
        if (component.isEmpty()) {
            Object instance;
            try {
                Level level = this.hasExplicitBinding(fallbackInjector, key) ? Level.FINE : Level.WARNING;
                log.log(level, () -> "Trying the fallback injector to create" + ComponentGraph.messageForNoGlobalComponent(clazz, node));
                if (level.intValue() > Level.INFO.intValue()) {
                    log.log(level, "A component of type " + String.valueOf(key.getTypeLiteral()) + " should probably be declared in services.xml. Not doing so may cause resource leaks and unnecessary reconstruction of components.");
                }
                instance = fallbackInjector.getInstance(key);
            }
            catch (ConfigurationException e) {
                throw Exceptions.removeStackTrace(new IllegalStateException((String)(this.messageForMultipleClassLoaders(clazz).isEmpty() ? "No global" + ComponentGraph.messageForNoGlobalComponent(clazz, node) : this.messageForMultipleClassLoaders(clazz))));
            }
            component = Optional.of((Node)this.matchingGuiceNode(key, instance).orElseGet(() -> {
                GuiceNode guiceNode = new GuiceNode(instance, key.getAnnotation());
                this.add(guiceNode);
                return guiceNode;
            }));
        }
        return component.get();
    }

    private boolean hasExplicitBinding(Injector injector, Key<?> key) {
        log.log(Level.FINE, () -> "Injector binding for " + String.valueOf(key) + ": " + String.valueOf(injector.getExistingBinding(key)));
        return injector.getExistingBinding(key) != null;
    }

    private Node handleComponentParameter(Node node, Injector fallbackInjector, Class<?> clazz, Collection<Annotation> annotations) {
        List<Annotation> bindingAnnotations = annotations.stream().filter(ComponentGraph::isBindingAnnotation).toList();
        Key<?> key = this.getKey(clazz, bindingAnnotations.stream().findFirst());
        if (bindingAnnotations.size() > 1) {
            throw new RuntimeException(String.format("More than one binding annotation used in class '%s'", node.instanceType()));
        }
        Collection<ComponentNode> injectedNodesOfCorrectType = ComponentGraph.matchingComponentNodes(node.componentsToInject, key);
        if (injectedNodesOfCorrectType.size() == 0) {
            return this.lookupOrCreateGlobalComponent(node, fallbackInjector, clazz, key);
        }
        if (injectedNodesOfCorrectType.size() == 1) {
            return (Node)Iterables.get(injectedNodesOfCorrectType, (int)0);
        }
        throw new RuntimeException(String.format("Multiple components of type '%s' injected into component '%s'", clazz.getName(), node.instanceType()));
    }

    private static String messageForNoGlobalComponent(Class<?> clazz, Node node) {
        return String.format(" component of class %s to inject into component %s.", clazz.getName(), node.idAndType());
    }

    private String messageForMultipleClassLoaders(Class<?> clazz) {
        String errMsg = "Class " + clazz.getName() + " is provided by the framework, and cannot be embedded in a user bundle. To resolve this problem, please refer to osgi-classloading.html#multiple-implementations in the documentation";
        try {
            Class<?> resolvedClass = Class.forName(clazz.getName(), false, this.getClass().getClassLoader());
            if (!resolvedClass.equals(clazz)) {
                return errMsg;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return "";
    }

    public static Node getNode(ComponentGraph graph, String componentId) {
        return graph.nodesById.get(new ComponentId(componentId));
    }

    private static <T> Collection<T> nodesOfType(Collection<Node> nodes, Class<T> clazz) {
        ArrayList<T> ret = new ArrayList<T>();
        for (Node node : nodes) {
            if (!clazz.isInstance(node)) continue;
            ret.add(clazz.cast(node));
        }
        return ret;
    }

    private static Collection<ComponentNode> matchingComponentNodes(Collection<Node> nodes, Key<?> key) {
        return ComponentGraph.matchingNodes(nodes, ComponentNode.class, key);
    }

    private static <T extends Node> Collection<T> matchingNodes(Collection<Node> nodes, Class<T> nodeType, Key<?> key) {
        Class clazz = key.getTypeLiteral().getRawType();
        Annotation annotation = key.getAnnotation();
        List<Node> filteredByClass = ComponentGraph.nodesOfType(nodes, nodeType).stream().filter(node -> clazz.isAssignableFrom(node.componentType())).toList();
        if (filteredByClass.size() == 1) {
            return filteredByClass;
        }
        List<Node> filteredByClassAndAnnotation = filteredByClass.stream().filter(node -> annotation == null && node.instanceKey().getAnnotation() == null || annotation.equals(node.instanceKey().getAnnotation())).toList();
        if (filteredByClassAndAnnotation.size() > 0) {
            return filteredByClassAndAnnotation;
        }
        return filteredByClass;
    }

    public static boolean isBindingAnnotation(Annotation annotation) {
        LinkedList queue = new LinkedList();
        queue.add(annotation.getClass());
        queue.addAll(List.of(annotation.getClass().getInterfaces()));
        while (!queue.isEmpty()) {
            Class clazz = (Class)queue.removeFirst();
            if (clazz.getAnnotation(BindingAnnotation.class) != null) {
                return true;
            }
            if (clazz.getSuperclass() == null) continue;
            queue.addFirst(clazz.getSuperclass());
        }
        return false;
    }

    private static List<Node> topologicalSort(Collection<Node> nodes) {
        HashMap numIncoming = new HashMap();
        nodes.forEach(node -> node.usedComponents().forEach(injectedNode -> numIncoming.merge(injectedNode.componentId(), 1, (a, b) -> a + b)));
        LinkedList<Node> sorted = new LinkedList<Node>();
        ArrayList<Node> unsorted = new ArrayList<Node>(nodes);
        while (!unsorted.isEmpty()) {
            ArrayList ready = new ArrayList();
            ArrayList<Node> notReady = new ArrayList<Node>();
            unsorted.forEach(node -> {
                if (numIncoming.getOrDefault(node.componentId(), 0) == 0) {
                    ready.add(node);
                } else {
                    notReady.add((Node)node);
                }
            });
            if (ready.isEmpty()) {
                throw new IllegalStateException("There is a cycle in the component injection graph: " + String.valueOf(ComponentGraph.findCycle(notReady)));
            }
            ready.forEach(node -> node.usedComponents().forEach(injectedNode -> numIncoming.merge(injectedNode.componentId(), -1, (a, b) -> a + b)));
            sorted.addAll(0, ready);
            unsorted = notReady;
        }
        return sorted;
    }

    private static List<String> findCycle(List<Node> nodes) {
        Graph<String> cyclicGraph = new Graph<String>();
        for (Node node : nodes) {
            for (Node adjacent : node.usedComponents()) {
                cyclicGraph.edge(node.componentId().stringValue(), adjacent.componentId().stringValue());
            }
        }
        return new CycleFinder(cyclicGraph).findCycle();
    }
}

