/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.BindingNotFoundException;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.server.jetty.CompletionHandlers;
import com.yahoo.jdisc.http.server.jetty.ContentChannels;
import com.yahoo.jdisc.http.server.jetty.RequestException;
import com.yahoo.jdisc.http.server.jetty.RequestMetricReporter;
import com.yahoo.jdisc.service.BindingSetNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Callback;

class JettyResponseWriter
implements ResponseHandler {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final Logger log = Logger.getLogger(JettyResponseWriter.class.getName());
    private final Object monitor = new Object();
    private final Request jettyRequest;
    private final org.eclipse.jetty.server.Response jettyResponse;
    private final RequestMetricReporter metricReporter;
    private final CompletableFuture<Void> responseCompletion = new CompletableFuture();
    private ResponseContentChannel contentChannel;
    private Response jdiscResponse;

    JettyResponseWriter(Request jettyRequest, org.eclipse.jetty.server.Response jettyResponse, RequestMetricReporter metricReporter) {
        this.jettyRequest = jettyRequest;
        this.jettyResponse = jettyResponse;
        this.metricReporter = metricReporter;
    }

    CompletableFuture<Void> writeCompletion() {
        return this.responseCompletion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentChannel handleResponse(Response jdiscResponse) {
        Objects.requireNonNull(jdiscResponse, "Response is null");
        Object object = this.monitor;
        synchronized (object) {
            if (this.jettyResponse.isCommitted()) {
                return ContentChannels.noop();
            }
            if (this.contentChannel != null) {
                this.contentChannel.invalidated = true;
            }
            this.jdiscResponse = jdiscResponse;
            this.contentChannel = new ResponseContentChannel();
            return this.contentChannel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryWriteErrorResponse(Throwable error, Callback callback, boolean developerMode) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.jettyResponse.isCommitted()) {
                callback.succeeded();
                return;
            }
            org.eclipse.jetty.server.Response.writeError((Request)this.jettyRequest, (org.eclipse.jetty.server.Response)this.jettyResponse, (Callback)Callback.from(() -> ((Callback)callback).succeeded()), (int)JettyResponseWriter.getStatusCode(error), (String)JettyResponseWriter.getReasonPhrase(error, developerMode));
        }
    }

    private static int getStatusCode(Throwable t) {
        if (t instanceof BindingNotFoundException || t instanceof BindingSetNotFoundException) {
            return 404;
        }
        if (t instanceof RequestException) {
            return ((RequestException)t).getResponseStatus();
        }
        if (t instanceof TimeoutException) {
            return 503;
        }
        return 500;
    }

    private static String getReasonPhrase(Throwable t, boolean developerMode) {
        if (developerMode) {
            StringWriter out = new StringWriter();
            t.printStackTrace(new PrintWriter(out));
            return out.toString();
        }
        if (t.getMessage() != null) {
            return t.getMessage();
        }
        return t.toString();
    }

    private class ResponseContentChannel
    implements ContentChannel {
        boolean invalidated = false;
        private final Queue<WriteTask> writeQueue = new LinkedList<WriteTask>();
        private boolean canWrite = true;

        private ResponseContentChannel() {
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            Objects.requireNonNull(buf, "Buffer is null");
            this.enqueueTask(new WriteTask(buf, handler));
        }

        public void close(CompletionHandler handler) {
            this.enqueueTask(new WriteTask(null, handler));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueueTask(WriteTask task) {
            Object object = JettyResponseWriter.this.monitor;
            synchronized (object) {
                this.writeQueue.add(task);
                this.tryProcessQueue();
            }
        }

        private void tryProcessQueue() {
            if (this.canWrite && !this.writeQueue.isEmpty()) {
                this.performWrite(this.writeQueue.poll());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performWrite(final WriteTask task) {
            try {
                Object object = JettyResponseWriter.this.monitor;
                synchronized (object) {
                    if (this.invalidated) {
                        task.handler.failed((Throwable)new IllegalStateException("Content channel is invalidated"));
                        return;
                    }
                    if (!JettyResponseWriter.this.jettyResponse.isCommitted()) {
                        JettyResponseWriter.this.jettyResponse.setStatus(JettyResponseWriter.this.jdiscResponse.getStatus());
                        HttpFields.Mutable jettyHeaders = JettyResponseWriter.this.jettyResponse.getHeaders();
                        JettyResponseWriter.this.jdiscResponse.headers().forEach((name, values) -> values.stream().filter(Objects::nonNull).forEach(value -> jettyHeaders.add(name, value)));
                        if (jettyHeaders.get(HttpHeader.CONTENT_TYPE) == null) {
                            jettyHeaders.add(HttpHeader.CONTENT_TYPE, "text/plain;charset=utf-8");
                        }
                        JettyResponseWriter.this.jettyRequest.setAttribute("requestType", (Object)JettyResponseWriter.this.jdiscResponse.getRequestType());
                    }
                }
                this.canWrite = false;
                JettyResponseWriter.this.jettyResponse.write(task.buf == null, Objects.requireNonNullElse(task.buf, EMPTY_BUFFER), new Callback(){

                    public void succeeded() {
                        if (task.buf == null) {
                            JettyResponseWriter.this.responseCompletion.complete(null);
                        }
                        ResponseContentChannel.this.completeAndFinishTask(task.handler, CompletionHandler::completed);
                        if (task.buf != null) {
                            JettyResponseWriter.this.metricReporter.successfulWrite(task.buf.remaining());
                        }
                    }

                    public void failed(Throwable x) {
                        JettyResponseWriter.this.responseCompletion.completeExceptionally(x);
                        ResponseContentChannel.this.completeAndFinishTask(task.handler, h -> h.failed(x));
                        JettyResponseWriter.this.metricReporter.failedWrite();
                    }
                });
            }
            catch (Throwable t) {
                JettyResponseWriter.this.responseCompletion.completeExceptionally(t);
                this.completeAndFinishTask(task.handler, h -> h.failed(t));
                JettyResponseWriter.this.metricReporter.failedWrite();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeAndFinishTask(CompletionHandler handler, Consumer<CompletionHandler> invocation) {
            try {
                invocation.accept(handler != null ? handler : CompletionHandlers.noop());
            }
            catch (Throwable ex) {
                log.log(Level.WARNING, "Failed to call completion handler", ex);
            }
            finally {
                Object object = JettyResponseWriter.this.monitor;
                synchronized (object) {
                    this.canWrite = true;
                    this.tryProcessQueue();
                }
            }
        }

        private record WriteTask(ByteBuffer buf, CompletionHandler handler) {
        }
    }
}

