/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.threadpool;

import ai.vespa.metrics.ContainerMetrics;
import com.yahoo.jdisc.Metric;
import java.util.Map;

class ThreadPoolMetric {
    private static final String THREAD_POOL_NAME_DIMENSION = "threadpool";
    private final Metric metric;
    private final Metric.Context defaultContext;
    private final String threadPoolName;

    ThreadPoolMetric(Metric metric, String threadPoolName) {
        this.metric = metric;
        this.threadPoolName = threadPoolName;
        this.defaultContext = metric.createContext(Map.of(THREAD_POOL_NAME_DIMENSION, threadPoolName));
    }

    void reportRejectRequest() {
        this.metric.add(ContainerMetrics.SERVER_REJECTED_REQUESTS.baseName(), (Number)1L, this.defaultContext);
        this.metric.add(ContainerMetrics.JDISC_THREAD_POOL_REJECTED_TASKS.baseName(), (Number)1L, this.defaultContext);
    }

    void reportThreadPoolSize(long size) {
        this.metric.set(ContainerMetrics.SERVER_THREAD_POOL_SIZE.baseName(), (Number)size, this.defaultContext);
        this.metric.set(ContainerMetrics.JDISC_THREAD_POOL_SIZE.baseName(), (Number)size, this.defaultContext);
    }

    void reportMaxAllowedThreadPoolSize(long size) {
        this.metric.set(ContainerMetrics.JDISC_THREAD_POOL_MAX_ALLOWED_SIZE.baseName(), (Number)size, this.defaultContext);
    }

    void reportActiveThreads(long threads) {
        this.metric.set(ContainerMetrics.SERVER_ACTIVE_THREADS.baseName(), (Number)threads, this.defaultContext);
        this.metric.set(ContainerMetrics.JDISC_THREAD_POOL_ACTIVE_THREADS.baseName(), (Number)threads, this.defaultContext);
    }

    void reportWorkQueueCapacity(long capacity) {
        this.metric.set(ContainerMetrics.JDISC_THREAD_POOL_WORK_QUEUE_CAPACITY.baseName(), (Number)capacity, this.defaultContext);
    }

    void reportWorkQueueSize(long size) {
        this.metric.set(ContainerMetrics.JDISC_THREAD_POOL_WORK_QUEUE_SIZE.baseName(), (Number)size, this.defaultContext);
    }

    void reportUnhandledException(Throwable t) {
        Metric.Context ctx = this.metric.createContext(Map.of(THREAD_POOL_NAME_DIMENSION, this.threadPoolName, "exception", t.getClass().getSimpleName()));
        this.metric.set(ContainerMetrics.JDISC_THREAD_POOL_UNHANDLED_EXCEPTIONS.baseName(), (Number)1L, ctx);
    }
}

