/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.ChainedComponent;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.component.chain.model.ChainsModel;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.ConfigurationRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ChainsConfigurer {
    public static <COMPONENT extends ChainedComponent> void prepareChainRegistry(ComponentRegistry<Chain<COMPONENT>> registry, ChainsModel model, ComponentRegistry<COMPONENT> allComponents) {
        ChainsConfigurer.initDependencies(model, allComponents);
        ChainsConfigurer.instantiateChains(registry, model, allComponents);
    }

    private static <COMPONENT extends ChainedComponent> void initDependencies(ChainsModel model, ComponentRegistry<COMPONENT> allComponents) {
        for (ChainedComponentModel componentModel : model.allComponents()) {
            COMPONENT component = ChainsConfigurer.getComponentOrThrow(allComponents, componentModel.getComponentId().toSpecification());
            ((ChainedComponent)component).initDependencies(componentModel.dependencies);
        }
    }

    private static <COMPONENT extends ChainedComponent> COMPONENT getComponentOrThrow(ComponentRegistry<COMPONENT> registry, ComponentSpecification specification) {
        ChainedComponent component = (ChainedComponent)registry.getComponent(specification);
        if (component == null) {
            throw new ConfigurationRuntimeException("No such component '" + String.valueOf(specification) + "'");
        }
        return (COMPONENT)component;
    }

    private static <COMPONENT extends ChainedComponent> void instantiateChains(ComponentRegistry<Chain<COMPONENT>> chainRegistry, ChainsModel model, ComponentRegistry<COMPONENT> allComponents) {
        for (ChainSpecification chain : model.allChainsFlattened()) {
            try {
                Chain<COMPONENT> componentChain = new Chain<COMPONENT>(chain.componentId, ChainsConfigurer.resolveComponents(chain.componentReferences, allComponents), chain.phases());
                chainRegistry.register(chain.componentId, componentChain);
            }
            catch (Exception e) {
                throw new ConfigurationRuntimeException("Invalid chain '" + String.valueOf(chain.componentId) + "'", (Throwable)e);
            }
        }
    }

    private static <T extends ChainedComponent> List<T> resolveComponents(Set<ComponentSpecification> componentSpecifications, ComponentRegistry<T> allComponents) {
        ArrayList<T> components = new ArrayList<T>(componentSpecifications.size());
        for (ComponentSpecification componentSpec : componentSpecifications) {
            T component = ChainsConfigurer.getComponentOrThrow(allComponents, componentSpec);
            components.add(component);
        }
        return components;
    }
}

