/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import java.util.LinkedHashMap;
import java.util.Map;

public class LevelsModSpec {
    private static final String ON = "on";
    private static final String OFF = "off";
    private Map<String, String> levelMods = LevelsModSpec.defaultLogLevels();

    private static Map<String, String> defaultLogLevels() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("fatal", ON);
        m.put("error", ON);
        m.put("warning", ON);
        m.put("info", ON);
        m.put("event", ON);
        m.put("config", ON);
        m.put("debug", OFF);
        m.put("spam", OFF);
        return m;
    }

    private void setAll(String value) {
        for (String k : this.levelMods.keySet()) {
            this.levelMods.put(k, value);
        }
    }

    private void setAll() {
        this.setAll(ON);
    }

    private void clearAll() {
        this.setAll(OFF);
    }

    public LevelsModSpec addModifications(String mods) {
        for (String s : mods.split("[+ ,]")) {
            String offOn = ON;
            if (s.startsWith("-")) {
                offOn = OFF;
                s = s.substring(1);
            }
            if (s.isEmpty()) continue;
            if (s.equals("all")) {
                this.setAll(offOn);
                continue;
            }
            if (this.levelMods.containsKey(s)) {
                this.levelMods.put(s, offOn);
                continue;
            }
            throw new IllegalArgumentException("Unknown log level: " + s);
        }
        return this;
    }

    public LevelsModSpec setLevels(String levels) {
        if (!levels.startsWith("+") && !levels.startsWith("-")) {
            this.clearAll();
        }
        return this.addModifications(levels);
    }

    public String toLogctlModSpec() {
        StringBuilder spec = new StringBuilder();
        boolean comma = false;
        for (Map.Entry<String, String> entry : this.levelMods.entrySet()) {
            if (comma) {
                spec.append(",");
            }
            spec.append(entry.getKey());
            spec.append("=");
            spec.append(entry.getValue());
            comma = true;
        }
        return spec.toString();
    }
}

