/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.metrics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.yahoo.container.handler.metrics.JsonResponse;
import com.yahoo.json.Jackson;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ErrorResponse
extends JsonResponse {
    private static final Logger log = Logger.getLogger(ErrorResponse.class.getName());

    public ErrorResponse(int code, String message) {
        super(code, ErrorResponse.asErrorJson(message != null ? message : "<null>"));
    }

    static String asErrorJson(String message) {
        try {
            return Jackson.mapper().writeValueAsString(Map.of("error", message));
        }
        catch (JsonProcessingException e) {
            log.log(Level.WARNING, "Could not encode error message to json:", e);
            return "Could not encode error message to json, check the log for details.";
        }
    }
}

