/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.request;

import com.yahoo.processing.request.CloneHelper;
import com.yahoo.processing.request.CompoundName;
import java.util.HashMap;
import java.util.Map;

public class Properties
implements Cloneable {
    private static final CloneHelper cloneHelper = new CloneHelper();
    private Properties chained = null;

    public Properties chain(Properties chained) {
        this.chained = chained;
        return chained;
    }

    public Properties chained() {
        return this.chained;
    }

    public final <T extends Properties> T getInstance(Class<T> propertyClass) {
        if (propertyClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this.chained == null) {
            return null;
        }
        return this.chained.getInstance(propertyClass);
    }

    public final Map<String, Object> listProperties() {
        return this.listProperties(CompoundName.empty);
    }

    public final Map<String, Object> listProperties(Map<String, String> context) {
        return this.listProperties(CompoundName.empty, context, this);
    }

    public final Map<String, Object> listProperties(CompoundName path) {
        return this.listProperties(path, null, this);
    }

    public final Map<String, Object> listProperties(String path) {
        return this.listProperties(new CompoundName(path), null, this);
    }

    public final Map<String, Object> listProperties(CompoundName path, Map<String, String> context) {
        return this.listProperties(path, context, this);
    }

    public final Map<String, Object> listProperties(String path, Map<String, String> context) {
        return this.listProperties(new CompoundName(path), context, this);
    }

    public Map<String, Object> listProperties(CompoundName path, Map<String, String> context, Properties substitution) {
        if (path == null) {
            path = CompoundName.empty;
        }
        if (this.chained() == null) {
            return new HashMap<String, Object>();
        }
        return this.chained().listProperties(path, context, substitution);
    }

    public final Map<String, Object> listProperties(String path, Map<String, String> context, Properties substitution) {
        return this.listProperties(new CompoundName(path), context, substitution);
    }

    public Object get(CompoundName name, Map<String, String> context, Properties substitution) {
        if (this.chained == null) {
            return null;
        }
        return this.chained.get(name, context, substitution);
    }

    public final Object get(String name, Map<String, String> context, Properties substitution) {
        return this.get(new CompoundName(name), context, substitution);
    }

    public final Object get(CompoundName name, Map<String, String> context) {
        return this.get(name, context, this);
    }

    public final Object get(String name, Map<String, String> context) {
        return this.get(new CompoundName(name), context, this);
    }

    public final Object get(CompoundName name) {
        return this.get(name, null, this);
    }

    public final Object get(String name) {
        return this.get(new CompoundName(name), null, this);
    }

    public final Object get(CompoundName name, Object defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public final Object get(String name, Object defaultValue) {
        return this.get(new CompoundName(name), defaultValue);
    }

    public void set(CompoundName name, Object value, Map<String, String> context) {
        if (this.chained == null) {
            throw new RuntimeException("Property '" + String.valueOf(name) + "->" + String.valueOf(value) + "' was not accepted in this property chain");
        }
        this.chained.set(name, value, context);
    }

    public final void set(String name, Object value, Map<String, String> context) {
        this.set(new CompoundName(name), value, context);
    }

    public final void set(CompoundName name, Object value) {
        this.set(name, value, null);
    }

    public final void set(String name, Object value) {
        this.set(new CompoundName(name), value, Map.of());
    }

    public void clearAll(CompoundName name, Map<String, String> context) {
        if (this.chained == null) {
            throw new RuntimeException("Property '" + String.valueOf(name) + "' was not accepted in this property chain");
        }
        this.chained.clearAll(name, context);
    }

    public final void clearAll(String name, Object value, Map<String, String> context) {
        this.set(new CompoundName(name), value, context);
    }

    public final void clearAll(CompoundName name) {
        this.clearAll(name, null);
    }

    public final void clearAll(String name) {
        this.clearAll(new CompoundName(name), Map.of());
    }

    public final boolean getBoolean(CompoundName name) {
        return this.getBoolean(name, false);
    }

    public final boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public final boolean getBoolean(CompoundName key, boolean defaultValue) {
        return Properties.asBoolean(this.get(key), defaultValue);
    }

    public final boolean getBoolean(String key, boolean defaultValue) {
        return Properties.asBoolean(this.get(key), defaultValue);
    }

    protected static boolean asBoolean(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String s = value.toString();
        int sz = s.length();
        return switch (sz) {
            case 0 -> true;
            case 4 -> {
                if ((s.charAt(0) | 0x20) == 116 && (s.charAt(1) | 0x20) == 114 && (s.charAt(2) | 0x20) == 117 && (s.charAt(3) | 0x20) == 101) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public final String getString(CompoundName key) {
        return this.getString(key, null);
    }

    public final String getString(String key) {
        return this.getString(key, null);
    }

    public final String getString(CompoundName key, String defaultValue) {
        return Properties.asString(this.get(key), defaultValue);
    }

    public final String getString(String key, String defaultValue) {
        return Properties.asString(this.get(key), defaultValue);
    }

    protected static String asString(Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public final Integer getInteger(CompoundName name) {
        return this.getInteger(name, null);
    }

    public final Integer getInteger(String name) {
        return this.getInteger(name, null);
    }

    public final Integer getInteger(CompoundName name, Integer defaultValue) {
        return Properties.asInteger(this.get(name), defaultValue);
    }

    public final Integer getInteger(String name, Integer defaultValue) {
        return Properties.asInteger(this.get(name), defaultValue);
    }

    protected static Integer asInteger(Object value, Integer defaultValue) {
        try {
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            String stringValue = value.toString();
            if (stringValue.isEmpty()) {
                return defaultValue;
            }
            return Integer.valueOf(stringValue);
        }
        catch (IllegalArgumentException e) {
            throw new NumberFormatException("'" + String.valueOf(value) + "' is not a valid integer");
        }
    }

    public final Long getLong(CompoundName name) {
        return this.getLong(name, null);
    }

    public final Long getLong(String name) {
        return this.getLong(name, null);
    }

    public final Long getLong(CompoundName name, Long defaultValue) {
        return Properties.asLong(this.get(name), defaultValue);
    }

    public final Long getLong(String name, Long defaultValue) {
        return Properties.asLong(this.get(name), defaultValue);
    }

    protected static Long asLong(Object value, Long defaultValue) {
        try {
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            String stringValue = value.toString();
            if (stringValue.isEmpty()) {
                return defaultValue;
            }
            return Long.valueOf(value.toString());
        }
        catch (IllegalArgumentException e) {
            throw new NumberFormatException("Not a valid long");
        }
    }

    public final Double getDouble(CompoundName name) {
        return this.getDouble(name, null);
    }

    public final Double getDouble(String name) {
        return this.getDouble(name, null);
    }

    public final Double getDouble(CompoundName name, Double defaultValue) {
        return Properties.asDouble(this.get(name), defaultValue);
    }

    public final Double getDouble(String name, Double defaultValue) {
        return Properties.asDouble(this.get(name), defaultValue);
    }

    protected static Double asDouble(Object value, Double defaultValue) {
        try {
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            String stringValue = value.toString();
            if (stringValue.isEmpty()) {
                return defaultValue;
            }
            return Double.valueOf(value.toString());
        }
        catch (IllegalArgumentException e) {
            throw new NumberFormatException("Not a valid double");
        }
    }

    public Properties clone() {
        try {
            Properties clone = (Properties)super.clone();
            if (this.chained != null) {
                clone.chained = this.chained.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Will never happen");
        }
    }

    public static Map<CompoundName, Object> cloneMap(Map<CompoundName, Object> map) {
        return cloneHelper.cloneMap(map);
    }

    public static Object clone(Object object) {
        return cloneHelper.clone(object);
    }
}

