/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di;

import com.google.inject.Injector;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.SubscriberClosedException;
import com.yahoo.container.ComponentsConfig;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.ConfigRetriever;
import com.yahoo.container.di.Osgi;
import com.yahoo.container.di.componentgraph.core.ComponentGraph;
import com.yahoo.container.di.componentgraph.core.ComponentNode;
import com.yahoo.container.di.componentgraph.core.Node;
import com.yahoo.container.di.config.ApplicationBundlesConfig;
import com.yahoo.container.di.config.PlatformBundlesConfig;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.yolean.UncheckedInterruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class Container {
    private static final Logger log = Logger.getLogger(Container.class.getName());
    private final SubscriberFactory subscriberFactory;
    private final ConfigKey<ApplicationBundlesConfig> applicationBundlesConfigKey;
    private final ConfigKey<PlatformBundlesConfig> platformBundlesConfigKey;
    private final ConfigKey<ComponentsConfig> componentsConfigKey;
    private final ComponentDeconstructor destructor;
    private final Osgi osgi;
    private final ConfigRetriever retriever;
    private List<String> platformBundles;
    private long previousConfigGeneration = -1L;
    private long leastGeneration = -1L;

    public Container(SubscriberFactory subscriberFactory, String configId, ComponentDeconstructor destructor, Osgi osgi) {
        this.subscriberFactory = subscriberFactory;
        this.destructor = destructor;
        this.osgi = osgi;
        this.applicationBundlesConfigKey = new ConfigKey(ApplicationBundlesConfig.class, configId);
        this.platformBundlesConfigKey = new ConfigKey(PlatformBundlesConfig.class, configId);
        this.componentsConfigKey = new ConfigKey(ComponentsConfig.class, configId);
        Set<ConfigKey<? extends ConfigInstance>> bootstrapKeys = Set.of(this.applicationBundlesConfigKey, this.platformBundlesConfigKey, this.componentsConfigKey);
        this.retriever = new ConfigRetriever(bootstrapKeys, subscriberFactory);
    }

    public ComponentGraphResult waitForNextGraphGeneration(ComponentGraph oldGraph, Injector fallbackInjector, boolean isInitializing) {
        try {
            ComponentGraph newGraph;
            try {
                newGraph = this.waitForNewConfigGenAndCreateGraph(oldGraph, fallbackInjector, isInitializing);
                newGraph.reuseNodes(oldGraph);
            }
            catch (Throwable t) {
                if (t instanceof SubscriberClosedException) {
                    log.fine("Closing down waitForNextGraphGeneration()");
                } else {
                    log.warning("Failed to set up component graph - uninstalling latest bundles. Bootstrap generation: " + this.getBootstrapGeneration());
                }
                Set<Bundle> newBundlesFromFailedGen = this.osgi.completeBundleGeneration(Osgi.GenerationStatus.FAILURE);
                this.deconstructComponentsAndBundles(this.getBootstrapGeneration(), newBundlesFromFailedGen, List.of());
                throw t;
            }
            try {
                this.constructComponents(newGraph);
            }
            catch (Throwable e) {
                log.warning("Failed to construct components for generation '" + newGraph.generation() + "' - scheduling partial graph for deconstruction");
                Set<Bundle> newBundlesFromFailedGen = this.osgi.completeBundleGeneration(Osgi.GenerationStatus.FAILURE);
                this.deconstructFailedGraph(oldGraph, newGraph, newBundlesFromFailedGen);
                throw e;
            }
            Set<Bundle> unusedBundlesFromPreviousGen = this.osgi.completeBundleGeneration(Osgi.GenerationStatus.SUCCESS);
            Runnable cleanupTask = this.createPreviousGraphDeconstructionTask(oldGraph, newGraph, unusedBundlesFromPreviousGen);
            return new ComponentGraphResult(newGraph, cleanupTask);
        }
        catch (Throwable t) {
            this.invalidateGeneration(oldGraph.generation(), t);
            throw t;
        }
    }

    private void constructComponents(ComponentGraph graph) {
        graph.nodes().forEach(n -> {
            if (Thread.interrupted()) {
                throw new UncheckedInterruptedException("Interrupted while constructing component graph", true);
            }
            n.constructInstance();
        });
    }

    private ComponentGraph waitForNewConfigGenAndCreateGraph(ComponentGraph graph, Injector fallbackInjector, boolean isInitializing) {
        ConfigRetriever.ConfigSnapshot snapshot;
        while (true) {
            snapshot = this.retriever.getConfigs(graph.configKeys(), this.leastGeneration, isInitializing);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("getConfigAndCreateGraph:\ngraph.configKeys = %s\ngraph.generation = %s\nsnapshot = %s\n", graph.configKeys(), graph.generation(), snapshot));
            }
            if (snapshot instanceof ConfigRetriever.BootstrapConfigs) {
                if (this.getBootstrapGeneration() <= this.previousConfigGeneration) {
                    throw new IllegalStateException(String.format("Got bootstrap configs out of sequence for old config generation %d.\nPrevious config generation is %d", this.getBootstrapGeneration(), this.previousConfigGeneration));
                }
                log.log(Level.FINE, () -> "Got new bootstrap generation\n" + this.configGenerationsString());
                if (graph.generation() == 0L) {
                    this.platformBundles = Container.getConfig(this.platformBundlesConfigKey, snapshot.configs()).bundlePaths();
                    this.osgi.installPlatformBundles(this.platformBundles);
                } else {
                    this.throwIfPlatformBundlesChanged(snapshot);
                }
                this.installApplicationBundles(snapshot.configs());
                graph = this.createComponentGraph(snapshot.configs(), this.getBootstrapGeneration(), fallbackInjector);
                continue;
            }
            if (snapshot instanceof ConfigRetriever.ComponentsConfigs) break;
        }
        log.log(Level.FINE, () -> "Got components configs,\n" + this.configGenerationsString());
        return this.createAndConfigureComponentGraph(snapshot.configs(), fallbackInjector);
    }

    private long getBootstrapGeneration() {
        return this.retriever.getBootstrapGeneration();
    }

    private long getComponentsGeneration() {
        return this.retriever.getComponentsGeneration();
    }

    private String configGenerationsString() {
        return String.format("bootstrap generation = %d\ncomponents generation: %d\nprevious generation: %d", this.getBootstrapGeneration(), this.getComponentsGeneration(), this.previousConfigGeneration);
    }

    private void throwIfPlatformBundlesChanged(ConfigRetriever.ConfigSnapshot snapshot) {
        List<String> checkPlatformBundles = Container.getConfig(this.platformBundlesConfigKey, snapshot.configs()).bundlePaths();
        if (!checkPlatformBundles.equals(this.platformBundles)) {
            throw new RuntimeException("Platform bundles are not allowed to change!\nOld: " + String.valueOf(this.platformBundles) + "\nNew: " + String.valueOf(checkPlatformBundles));
        }
    }

    private ComponentGraph createAndConfigureComponentGraph(Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> componentsConfigs, Injector fallbackInjector) {
        ComponentGraph componentGraph = this.createComponentGraph(componentsConfigs, this.getComponentsGeneration(), fallbackInjector);
        componentGraph.setAvailableConfigs(componentsConfigs);
        return componentGraph;
    }

    private void deconstructFailedGraph(ComponentGraph currentGraph, ComponentGraph failedGraph, Collection<Bundle> bundlesFromFailedGraph) {
        Set currentComponents = Collections.newSetFromMap(new IdentityHashMap(currentGraph.size()));
        currentComponents.addAll(currentGraph.allConstructedComponentsAndProviders());
        ArrayList<Object> unusedComponents = new ArrayList<Object>();
        for (Object component : failedGraph.allConstructedComponentsAndProviders()) {
            if (currentComponents.contains(component)) continue;
            unusedComponents.add(component);
        }
        this.deconstructComponentsAndBundles(failedGraph.generation(), bundlesFromFailedGraph, unusedComponents);
    }

    private void deconstructComponentsAndBundles(long generation, Collection<Bundle> bundlesFromFailedGraph, List<Object> unusedComponents) {
        this.destructor.deconstruct(generation, unusedComponents, bundlesFromFailedGraph);
    }

    private Runnable createPreviousGraphDeconstructionTask(ComponentGraph oldGraph, ComponentGraph newGraph, Collection<Bundle> obsoleteBundles) {
        IdentityHashMap newComponents = new IdentityHashMap(newGraph.size());
        for (Object component : newGraph.allConstructedComponentsAndProviders()) {
            newComponents.put(component, null);
        }
        ArrayList<Object> obsoleteComponents = new ArrayList<Object>();
        for (Object component : oldGraph.allConstructedComponentsAndProviders()) {
            if (newComponents.containsKey(component)) continue;
            obsoleteComponents.add(component);
        }
        return () -> this.destructor.deconstruct(oldGraph.generation(), obsoleteComponents, obsoleteBundles);
    }

    private void installApplicationBundles(Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configsIncludingBootstrapConfigs) {
        ApplicationBundlesConfig applicationBundlesConfig = Container.getConfig(this.applicationBundlesConfigKey, configsIncludingBootstrapConfigs);
        this.osgi.useApplicationBundles(applicationBundlesConfig.bundles(), this.getBootstrapGeneration());
    }

    private ComponentGraph createComponentGraph(Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configsIncludingBootstrapConfigs, long generation, Injector fallbackInjector) {
        this.previousConfigGeneration = generation;
        ComponentGraph graph = new ComponentGraph(generation);
        ComponentsConfig componentsConfig = Container.getConfig(this.componentsConfigKey, configsIncludingBootstrapConfigs);
        if (componentsConfig == null) {
            throw new ConfigurationRuntimeException("The set of all configs does not include a valid 'components' config. Config set: " + String.valueOf(configsIncludingBootstrapConfigs.keySet()));
        }
        this.addNodes(componentsConfig, graph);
        this.injectNodes(componentsConfig, graph);
        graph.complete(fallbackInjector);
        return graph;
    }

    private void addNodes(ComponentsConfig componentsConfig, ComponentGraph graph) {
        for (ComponentsConfig.Components config : componentsConfig.components()) {
            BundleInstantiationSpecification specification = Container.bundleInstantiationSpecification(config);
            Class<?> componentClass = this.osgi.resolveClass(specification);
            ComponentNode componentNode = new ComponentNode(specification.id, config.configId(), componentClass, null);
            graph.add(componentNode);
        }
    }

    private void injectNodes(ComponentsConfig config, ComponentGraph graph) {
        for (ComponentsConfig.Components component : config.components()) {
            Node componentNode = ComponentGraph.getNode(graph, component.id());
            for (ComponentsConfig.Components.Inject inject : component.inject()) {
                componentNode.inject(ComponentGraph.getNode(graph, inject.id()));
            }
        }
    }

    private void invalidateGeneration(long generation, Throwable cause) {
        this.leastGeneration = Math.max(this.retriever.getComponentsGeneration(), this.retriever.getBootstrapGeneration()) + 1L;
        if (!(cause instanceof InterruptedException || cause instanceof ConfigInterruptedException || cause instanceof SubscriberClosedException)) {
            log.log(Level.WARNING, Container.newGraphErrorMessage(generation, cause), cause);
        }
    }

    private static String newGraphErrorMessage(long generation, Throwable cause) {
        String failedFirstMessage = "Failed to set up first component graph";
        String failedNewMessage = "Failed to set up new component graph";
        String constructMessage = " due to error when constructing one of the components";
        String retainMessage = ". Retaining previous component generation.";
        if (generation == 0L) {
            if (cause instanceof ComponentNode.ComponentConstructorException) {
                return failedFirstMessage + constructMessage;
            }
            return failedFirstMessage;
        }
        if (cause instanceof ComponentNode.ComponentConstructorException) {
            return failedNewMessage + constructMessage + retainMessage;
        }
        return failedNewMessage + retainMessage;
    }

    public void shutdown(ComponentGraph graph) {
        this.shutdownConfigRetriever();
        if (graph != null) {
            this.deconstructComponentsAndBundles(graph.generation(), List.of(), graph.allConstructedComponentsAndProviders());
            this.destructor.shutdown();
        }
    }

    public void shutdownConfigRetriever() {
        this.retriever.shutdown();
    }

    public void reloadConfig(long generation) {
        this.subscriberFactory.reloadActiveSubscribers(generation);
    }

    public static <T extends ConfigInstance> T getConfig(ConfigKey<T> key, Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configs) {
        ConfigInstance inst = configs.get(key);
        if (inst == null || key.getConfigClass() == null) {
            throw new RuntimeException("Missing config " + String.valueOf(key));
        }
        return (T)((ConfigInstance)key.getConfigClass().cast(inst));
    }

    private static BundleInstantiationSpecification bundleInstantiationSpecification(ComponentsConfig.Components config) {
        return BundleInstantiationSpecification.fromStrings(config.id(), config.classId(), config.bundle());
    }

    public static class ComponentGraphResult {
        private final ComponentGraph newGraph;
        private final Runnable oldComponentsCleanupTask;

        public ComponentGraphResult(ComponentGraph newGraph, Runnable oldComponentsCleanupTask) {
            this.newGraph = newGraph;
            this.oldComponentsCleanupTask = oldComponentsCleanupTask;
        }

        public ComponentGraph newGraph() {
            return this.newGraph;
        }

        public Runnable oldComponentsCleanupTask() {
            return this.oldComponentsCleanupTask;
        }
    }
}

