/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.ConnectorConfig;
import java.util.Optional;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

class TlsClientAuthenticationEnforcer
extends Handler.Wrapper {
    private final ConnectorConfig.TlsClientAuthEnforcer cfg;

    TlsClientAuthenticationEnforcer(ConnectorConfig.TlsClientAuthEnforcer cfg, Handler handler) {
        super(handler);
        if (!cfg.enable()) {
            throw new IllegalArgumentException();
        }
        this.cfg = cfg;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (!this.isRequestToWhitelistedBinding(request) && !this.hasClientX509Certificate(request)) {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)401, (String)"Client did not present a x509 certificate, or presented a certificate not issued by any of the CA certificates in trust store.");
            return true;
        }
        return super.handle(request, response, callback);
    }

    private boolean isRequestToWhitelistedBinding(Request request) {
        return this.cfg.pathWhitelist().contains(request.getHttpURI().getPath());
    }

    private boolean hasClientX509Certificate(Request request) {
        return Optional.ofNullable(request.getAttribute("org.eclipse.jetty.io.Endpoint.SslSessionData")).map(EndPoint.SslSessionData.class::cast).map(d -> d.peerCertificates() != null).orElse(false);
    }
}

