/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;

class ConnectorSpecificContextHandler
extends ContextHandler {
    private final JDiscServerConnector connector;

    ConnectorSpecificContextHandler(JDiscServerConnector c, Handler handler) {
        super(handler);
        this.connector = c;
        List<String> allowedServerNames = c.connectorConfig().serverName().allowed();
        if (allowedServerNames.isEmpty()) {
            this.setVirtualHosts(List.of("@%s".formatted(c.getName())));
        } else {
            List<String> virtualHosts = allowedServerNames.stream().map(name -> "%s@%s".formatted(name, c.getName())).toList();
            this.setVirtualHosts(virtualHosts);
        }
    }

    public boolean checkVirtualHost(Request req) {
        if (req.getHttpURI().getPath().equals("/status.html") && req.getConnectionMetaData().getConnector() == this.connector) {
            return true;
        }
        return super.checkVirtualHost(req);
    }
}

