/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.stream.Stream;

public class FileWrapper {
    long getFileAgeInSeconds(Path path) throws IOException {
        Instant lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        return Instant.now().getEpochSecond() - lastModifiedTime.getEpochSecond();
    }

    Stream<Path> walkTree(Path path) throws IOException {
        return Files.walk(path, new FileVisitOption[0]);
    }

    boolean isRegularFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }
}

