/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.config;

import com.yahoo.container.core.config.BundleStarter;
import com.yahoo.container.core.config.DiskBundleInstaller;
import com.yahoo.osgi.Osgi;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class PlatformBundleLoader {
    private static final Logger log = Logger.getLogger(PlatformBundleLoader.class.getName());
    private final Osgi osgi;
    private final DiskBundleInstaller installer;
    private Set<Bundle> installedBundles;
    private boolean hasLoadedBundles = false;

    public PlatformBundleLoader(Osgi osgi) {
        this(osgi, new DiskBundleInstaller());
    }

    PlatformBundleLoader(Osgi osgi, DiskBundleInstaller installer) {
        this.osgi = osgi;
        this.installer = installer;
    }

    public void useBundles(List<String> bundlePaths) {
        if (this.hasLoadedBundles) {
            log.log(Level.FINE, () -> "Platform bundles have already been installed.\nInstalled bundles: " + String.valueOf(this.installedBundles) + "\nGiven files: " + String.valueOf(bundlePaths));
            return;
        }
        this.installedBundles = this.install(bundlePaths);
        BundleStarter.startBundles(this.installedBundles);
        this.hasLoadedBundles = true;
    }

    private Set<Bundle> install(List<String> bundlesToInstall) {
        LinkedHashSet<Bundle> allInstalled = new LinkedHashSet<Bundle>();
        for (String bundlePath : bundlesToInstall) {
            try {
                allInstalled.addAll(this.installBundleFromDisk(bundlePath));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not install bundle '" + bundlePath + "'", e);
            }
        }
        return allInstalled;
    }

    private List<Bundle> installBundleFromDisk(String bundlePath) {
        log.log(Level.FINE, "Installing bundle from disk: " + bundlePath);
        List<Bundle> bundles = this.installer.installBundles(bundlePath, this.osgi);
        log.log(Level.FINE, "Installed " + bundles.size() + " bundles for file " + bundlePath);
        return bundles;
    }
}

