/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.common.base.Objects;
import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.container.logging.RequestLogEntry;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

class AccessLogRequestLog
extends AbstractLifeCycle
implements RequestLog {
    private static final Logger logger = Logger.getLogger(AccessLogRequestLog.class.getName());
    private static final List<String> LOGGED_REQUEST_HEADERS = List.of("Vespa-Client-Version");
    private final com.yahoo.container.logging.RequestLog requestLog;

    AccessLogRequestLog(com.yahoo.container.logging.RequestLog requestLog) {
        this.requestLog = requestLog;
    }

    public void log(Request request, Response response) {
        try {
            AccessLogEntry accessLogEntry;
            X509Certificate[] clientCert;
            int remotePort;
            RequestLogEntry.Builder builder = new RequestLogEntry.Builder();
            String peerAddress = Request.getRemoteAddr((Request)request);
            int peerPort = Request.getRemotePort((Request)request);
            long startTime = Request.getTimeStamp((Request)request);
            long endTime = System.currentTimeMillis();
            Integer statusCodeOverride = (Integer)request.getAttribute("ai.vespa.jetty.ACCESS_LOG_STATUS_CODE_OVERRIDE");
            builder.peerAddress(peerAddress).peerPort(peerPort).localPort(AccessLogRequestLog.getLocalPort(request)).timestamp(Instant.ofEpochMilli(startTime)).duration(Duration.ofMillis(Math.max(0L, endTime - startTime))).responseSize(Response.getContentBytesWritten((Response)response)).requestSize(Request.getContentBytesRead((Request)request)).statusCode(statusCodeOverride != null ? statusCodeOverride.intValue() : response.getStatus());
            AccessLogRequestLog.addNonNullValue(builder, request.getMethod(), RequestLogEntry.Builder::httpMethod);
            AccessLogRequestLog.addNonNullValue(builder, request.getHttpURI().getPath(), RequestLogEntry.Builder::rawPath);
            AccessLogRequestLog.addNonNullValue(builder, request.getConnectionMetaData().getProtocol(), RequestLogEntry.Builder::httpVersion);
            AccessLogRequestLog.addNonNullValue(builder, request.getHttpURI().getScheme(), RequestLogEntry.Builder::scheme);
            AccessLogRequestLog.addNonNullValue(builder, request.getHeaders().get("User-Agent"), RequestLogEntry.Builder::userAgent);
            AccessLogRequestLog.addNonNullValue(builder, AccessLogRequestLog.getServerName(request), RequestLogEntry.Builder::hostString);
            AccessLogRequestLog.addNonNullValue(builder, request.getHeaders().get("Referer"), RequestLogEntry.Builder::referer);
            AccessLogRequestLog.addNonNullValue(builder, request.getHttpURI().getQuery(), RequestLogEntry.Builder::rawQuery);
            HttpRequest jdiscRequest = (HttpRequest)((Object)request.getAttribute(HttpRequest.class.getName()));
            if (jdiscRequest != null) {
                AccessLogRequestLog.addNonNullValue(builder, jdiscRequest.getUserPrincipal(), RequestLogEntry.Builder::userPrincipal);
            }
            String requestFilterId = (String)request.getAttribute("jdisc.request.chain");
            AccessLogRequestLog.addNonNullValue(builder, requestFilterId, (b, chain) -> b.addExtraAttribute("request-chain", (String)chain));
            String responseFilterId = (String)request.getAttribute("jdisc.response.chain");
            AccessLogRequestLog.addNonNullValue(builder, responseFilterId, (b, chain) -> b.addExtraAttribute("response-chain", (String)chain));
            UUID connectionId = (UUID)request.getAttribute("jdisc.request.connection.id");
            AccessLogRequestLog.addNonNullValue(builder, connectionId, (b, uuid) -> b.connectionId(uuid.toString()));
            String remoteAddress = this.getRemoteAddress(request);
            if (!Objects.equal((Object)remoteAddress, (Object)peerAddress)) {
                builder.remoteAddress(remoteAddress);
            }
            if ((remotePort = this.getRemotePort(request)) != peerPort) {
                builder.remotePort(remotePort);
            }
            LOGGED_REQUEST_HEADERS.forEach(header -> {
                String value = request.getHeaders().get(header);
                if (value != null) {
                    builder.addExtraAttribute((String)header, value);
                }
            });
            EndPoint.SslSessionData sslSessionData = (EndPoint.SslSessionData)request.getAttribute("org.eclipse.jetty.io.Endpoint.SslSessionData");
            if (sslSessionData != null && (clientCert = sslSessionData.peerCertificates()) != null && clientCert.length > 0) {
                builder.sslPrincipal(clientCert[0].getSubjectX500Principal());
            }
            if ((accessLogEntry = (AccessLogEntry)request.getAttribute("ai.vespa.jetty.ACCESS_LOG_ENTRY")) != null) {
                Map<String, List<String>> extraAttributes = accessLogEntry.getKeyValues();
                if (extraAttributes != null) {
                    extraAttributes.forEach(builder::addExtraAttributes);
                }
                AccessLogRequestLog.addNonNullValue(builder, accessLogEntry.getHitCounts(), RequestLogEntry.Builder::hitCounts);
                AccessLogRequestLog.addNonNullValue(builder, accessLogEntry.getTrace(), RequestLogEntry.Builder::traceNode);
                accessLogEntry.getContent().ifPresent(builder::content);
            }
            AccessLogRequestLog.http2StreamId(request).ifPresent(streamId -> builder.addExtraAttribute("http2-stream-id", Integer.toString(streamId)));
            this.requestLog.log(builder.build());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to log access log entry: " + e.getMessage(), e);
        }
    }

    private static String getServerName(Request request) {
        try {
            return Request.getServerName((Request)request);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.FINE, e, () -> "Fallback to 'Host' header");
            return request.getHeaders().get("Host");
        }
    }

    private String getRemoteAddress(Request request) {
        for (String header : RequestUtils.getConnector(request).connectorConfig().accessLog().remoteAddressHeaders()) {
            String value = request.getHeaders().get(header);
            if (value == null) continue;
            return value;
        }
        return Request.getRemoteAddr((Request)request);
    }

    private int getRemotePort(Request request) {
        for (String header : RequestUtils.getConnector(request).connectorConfig().accessLog().remotePortHeaders()) {
            OptionalInt maybePort;
            String value = request.getHeaders().get(header);
            if (value == null || !(maybePort = AccessLogRequestLog.parsePort(value)).isPresent()) continue;
            return maybePort.getAsInt();
        }
        return Request.getRemotePort((Request)request);
    }

    private static int getLocalPort(Request request) {
        int connectorLocalPort = RequestUtils.getConnectorLocalPort(request);
        if (connectorLocalPort <= 0) {
            return Request.getLocalPort((Request)request);
        }
        return connectorLocalPort;
    }

    private static OptionalInt parsePort(String port) {
        try {
            return OptionalInt.of(Integer.parseInt(port));
        }
        catch (IllegalArgumentException e) {
            return OptionalInt.empty();
        }
    }

    private static OptionalInt http2StreamId(Request request) {
        if (request.getConnectionMetaData().getHttpVersion() != HttpVersion.HTTP_2) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(Integer.parseInt(request.getId()));
    }

    private static <T> void addNonNullValue(RequestLogEntry.Builder builder, T value, BiConsumer<RequestLogEntry.Builder, T> setter) {
        if (value != null) {
            setter.accept(builder, (RequestLogEntry.Builder)value);
        }
    }
}

