/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.jdisc.http.server.jetty.MetricDefinitions;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import com.yahoo.jdisc.http.server.jetty.SimpleConcurrentIdentityHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.EventsHandler;

class ConnectionMetricAggregator
extends EventsHandler
implements Connection.Listener {
    private final SimpleConcurrentIdentityHashMap<Connection, ConnectionMetrics> connectionsMetrics = new SimpleConcurrentIdentityHashMap();
    private final Metric metricAggregator;
    private final List<String> monitoringHandlerPaths;

    ConnectionMetricAggregator(ServerConfig serverConfig, Metric metricAggregator, Handler handler) {
        super(handler);
        this.monitoringHandlerPaths = serverConfig.metric().monitoringHandlerPaths();
        this.metricAggregator = metricAggregator;
    }

    public void onOpened(Connection connection) {
    }

    public void onClosed(Connection connection) {
        if (RequestUtils.isHttpServerConnection(connection)) {
            this.connectionsMetrics.remove(connection).ifPresent(metrics -> this.metricAggregator.set(MetricDefinitions.REQUESTS_PER_CONNECTION, (Number)metrics.requests.get(), metrics.metricContext));
        }
    }

    protected void onBeforeHandling(Request request) {
        if (this.monitoringHandlerPaths.stream().anyMatch(pathPrefix -> request.getHttpURI().getPath().startsWith((String)pathPrefix))) {
            return;
        }
        Connection connection = request.getConnectionMetaData().getConnection();
        if (RequestUtils.isHttpServerConnection(connection)) {
            ConnectionMetrics metrics = this.connectionsMetrics.computeIfAbsent(connection, () -> new ConnectionMetrics(RequestUtils.getConnector(request).getConnectorMetricContext()));
            metrics.requests.incrementAndGet();
        }
    }

    private static class ConnectionMetrics {
        final AtomicLong requests = new AtomicLong();
        final Metric.Context metricContext;

        ConnectionMetrics(Metric.Context metricContext) {
            this.metricContext = metricContext;
        }
    }
}

