/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class PrometheusHelper {
    private static final String HELP_LINE = "# HELP %s\n# TYPE %s untyped\n";
    private static final String METRIC_LINE = "%s{%s} %s %d\n";
    private static final String DIMENSION_KEY = "dimensions";
    private static final String METRIC_KEY = "metrics";
    private static final String APPLICATION_KEY = "application";

    protected static byte[] buildPrometheusOutput(List<JsonNode> metrics, long timestamp) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (JsonNode metric : metrics) {
            JsonNode metricDimensions = metric.get(DIMENSION_KEY);
            StringBuilder dimensionBuilder = new StringBuilder();
            Iterator it = metricDimensions.fieldNames();
            while (it.hasNext()) {
                String dimension = (String)it.next();
                dimensionBuilder.append(PrometheusHelper.sanitize(dimension)).append("=\"").append(metricDimensions.get(dimension).asText()).append("\",");
            }
            String application = metric.get(APPLICATION_KEY).asText();
            dimensionBuilder.append("vespa_service=\"").append(application).append("\",");
            String dimensions = dimensionBuilder.toString();
            JsonNode metricValues = metric.get(METRIC_KEY);
            Iterator it2 = metricValues.fieldNames();
            while (it2.hasNext()) {
                String metricName = (String)it2.next();
                Number metricVal = metricValues.get(metricName).numberValue();
                outputStream.write(PrometheusHelper.getMetricLines(PrometheusHelper.sanitize(metricName), dimensions, metricVal, timestamp));
            }
        }
        return outputStream.toByteArray();
    }

    private static byte[] getMetricLines(String metricName, String dimensions, Number value, long timestamp) {
        return (String.format(HELP_LINE, metricName, metricName) + String.format(METRIC_LINE, metricName, dimensions, value, timestamp)).getBytes();
    }

    private static String sanitize(String name) {
        return name.replaceAll("([-.])", "_");
    }
}

