// Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
package com.yahoo.osgi;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.test.NonWorkingOsgiFramework;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

import java.util.List;

/**
 * @author Tony Vaagenes
 * @author gjoranv
 */
public class MockOsgi extends NonWorkingOsgiFramework implements Osgi {

    @Override
    public Bundle[] getBundles() {
        return new Bundle[0];
    }

    @Override
    public List<Bundle> getCurrentBundles() {
        return List.of();
    }

    @Override
    public Bundle getBundle(ComponentSpecification bundleId) {
        return null;
    }

    @Override
    public List<Bundle> install(String absolutePath) {
        return List.of();
    }

}
