// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of container-http
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ContainerHttpConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "4480f9b26ed61468673eac2b741b57c8";
  public final static String CONFIG_DEF_NAME = "container-http";
  public final static String CONFIG_DEF_NAMESPACE = "container.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.core",
    "hostResponseHeaderKey string default=\"\"",
    "numQueriesToTraceOnDebugAfterConstruction int default=1000"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String hostResponseHeaderKey = null;
    private Integer numQueriesToTraceOnDebugAfterConstruction = null;

    public Builder() { }

    public Builder(ContainerHttpConfig config) {
      hostResponseHeaderKey(config.hostResponseHeaderKey());
      numQueriesToTraceOnDebugAfterConstruction(config.numQueriesToTraceOnDebugAfterConstruction());
    }

    private Builder override(Builder __superior) {
      if (__superior.hostResponseHeaderKey != null)
        hostResponseHeaderKey(__superior.hostResponseHeaderKey);
      if (__superior.numQueriesToTraceOnDebugAfterConstruction != null)
        numQueriesToTraceOnDebugAfterConstruction(__superior.numQueriesToTraceOnDebugAfterConstruction);
      return this;
    }

    public Builder hostResponseHeaderKey(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      hostResponseHeaderKey = __value;
      return this;
    }


    public Builder numQueriesToTraceOnDebugAfterConstruction(int __value) {
      numQueriesToTraceOnDebugAfterConstruction = __value;
      return this;
    }

    private Builder numQueriesToTraceOnDebugAfterConstruction(String __value) {
      return numQueriesToTraceOnDebugAfterConstruction(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ContainerHttpConfig build() {
      return new ContainerHttpConfig(this);
    }

  }

  // If non-empty, handlers should emit a header containing this string as key and the local host name as value
  private final StringNode hostResponseHeaderKey;
  // For debugging, number of requests to add trace and timing information too if debugging is enabled.
  private final IntegerNode numQueriesToTraceOnDebugAfterConstruction;

  public ContainerHttpConfig(Builder builder) {
    this(builder, true);
  }

  private ContainerHttpConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "container-http must be initialized: " + builder.__uninitialized);

    hostResponseHeaderKey = (builder.hostResponseHeaderKey == null) ?
        new StringNode("") : new StringNode(builder.hostResponseHeaderKey);
    numQueriesToTraceOnDebugAfterConstruction = (builder.numQueriesToTraceOnDebugAfterConstruction == null) ?
        new IntegerNode(1000) : new IntegerNode(builder.numQueriesToTraceOnDebugAfterConstruction);
  }

  /**
   * @return container-http.hostResponseHeaderKey
   */
  public String hostResponseHeaderKey() {
    return hostResponseHeaderKey.value();
  }

  /**
   * @return container-http.numQueriesToTraceOnDebugAfterConstruction
   */
  public int numQueriesToTraceOnDebugAfterConstruction() {
    return numQueriesToTraceOnDebugAfterConstruction.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ContainerHttpConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("container-http");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
