// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of qr
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class QrConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "91c452bf30e10b4c4904a941bed38a75";
  public final static String CONFIG_DEF_NAME = "qr";
  public final static String CONFIG_DEF_NAMESPACE = "container";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container",
    "filedistributor.configid reference default=\"\"",
    "rpc.enabled bool default=false",
    "rpc.port int default=8086",
    "rpc.host string default=\"\"",
    "rpc.slobrokId string default=\"\"",
    "discriminator string default=\"qrserver.0\" restart",
    "clustername string default=\"\"",
    "nodeIndex int default=0",
    "restartOnDeploy bool default=false restart",
    "restartOnInternalRedeploy enum { always, node_changes, content_changes, never } default=never restart",
    "shutdown.dumpHeapOnTimeout bool default=false",
    "shutdown.timeout double default=50.0"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Filedistributor.Builder filedistributor = new Filedistributor.Builder();
    public Rpc.Builder rpc = new Rpc.Builder();
    private String discriminator = null;
    private String clustername = null;
    private Integer nodeIndex = null;
    private Boolean restartOnDeploy = null;
    private RestartOnInternalRedeploy.Enum restartOnInternalRedeploy = null;
    public Shutdown.Builder shutdown = new Shutdown.Builder();

    public Builder() { }

    public Builder(QrConfig config) {
      filedistributor(new Filedistributor.Builder(config.filedistributor()));
      rpc(new Rpc.Builder(config.rpc()));
      discriminator(config.discriminator());
      clustername(config.clustername());
      nodeIndex(config.nodeIndex());
      restartOnDeploy(config.restartOnDeploy());
      restartOnInternalRedeploy(config.restartOnInternalRedeploy());
      shutdown(new Shutdown.Builder(config.shutdown()));
    }

    private Builder override(Builder __superior) {
      filedistributor(filedistributor.override(__superior.filedistributor));
      rpc(rpc.override(__superior.rpc));
      if (__superior.discriminator != null)
        discriminator(__superior.discriminator);
      if (__superior.clustername != null)
        clustername(__superior.clustername);
      if (__superior.nodeIndex != null)
        nodeIndex(__superior.nodeIndex);
      if (__superior.restartOnDeploy != null)
        restartOnDeploy(__superior.restartOnDeploy);
      if (__superior.restartOnInternalRedeploy != null)
        restartOnInternalRedeploy(__superior.restartOnInternalRedeploy);
      shutdown(shutdown.override(__superior.shutdown));
      return this;
    }

    public Builder filedistributor(Filedistributor.Builder __builder) {
      filedistributor = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder filedistributor(java.util.function.Consumer<Filedistributor.Builder> __func) {
      Filedistributor.Builder __inner = new Filedistributor.Builder();
      __func.accept(__inner);
      filedistributor = __inner;
      return this;
    }

    public Builder rpc(Rpc.Builder __builder) {
      rpc = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder rpc(java.util.function.Consumer<Rpc.Builder> __func) {
      Rpc.Builder __inner = new Rpc.Builder();
      __func.accept(__inner);
      rpc = __inner;
      return this;
    }

    public Builder discriminator(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      discriminator = __value;
      return this;
    }


    public Builder clustername(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      clustername = __value;
      return this;
    }


    public Builder nodeIndex(int __value) {
      nodeIndex = __value;
      return this;
    }

    private Builder nodeIndex(String __value) {
      return nodeIndex(Integer.valueOf(__value));
    }

    public Builder restartOnDeploy(boolean __value) {
      restartOnDeploy = __value;
      return this;
    }

    private Builder restartOnDeploy(String __value) {
      return restartOnDeploy(Boolean.valueOf(__value));
    }

    public Builder restartOnInternalRedeploy(RestartOnInternalRedeploy.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      restartOnInternalRedeploy = __value;
      return this;
    }

    private Builder restartOnInternalRedeploy(String __value) {
      return restartOnInternalRedeploy(RestartOnInternalRedeploy.Enum.valueOf(__value));
    }

    public Builder shutdown(Shutdown.Builder __builder) {
      shutdown = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder shutdown(java.util.function.Consumer<Shutdown.Builder> __func) {
      Shutdown.Builder __inner = new Shutdown.Builder();
      __func.accept(__inner);
      shutdown = __inner;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public QrConfig build() {
      return new QrConfig(this);
    }

  }

  private final Filedistributor filedistributor;
  private final Rpc rpc;
  // A unique identifier string for this QRS. The only guarantee given is
  // this string will be unique for every QRS in a Vespa application.
  private final StringNode discriminator;
  // Cluster name
  private final StringNode clustername;
  // Index of this container inside the cluster. Guaranteed to be non-negative
  // and unique for every container in a cluster, but not necessarily contiguous
  // or starting from zero.
  private final IntegerNode nodeIndex;
  // Force restart of container on deploy, and defer any changes until restart
  private final BooleanNode restartOnDeploy;
  // Specifies under what circumstances restart on deploy should apply to internal redeployments
  private final RestartOnInternalRedeploy restartOnInternalRedeploy;
  private final Shutdown shutdown;

  public QrConfig(Builder builder) {
    this(builder, true);
  }

  private QrConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "qr must be initialized: " + builder.__uninitialized);

    filedistributor = new Filedistributor(builder.filedistributor, throwIfUninitialized);
    rpc = new Rpc(builder.rpc, throwIfUninitialized);
    discriminator = (builder.discriminator == null) ?
        new StringNode("qrserver.0") : new StringNode(builder.discriminator);
    clustername = (builder.clustername == null) ?
        new StringNode("") : new StringNode(builder.clustername);
    nodeIndex = (builder.nodeIndex == null) ?
        new IntegerNode(0) : new IntegerNode(builder.nodeIndex);
    restartOnDeploy = (builder.restartOnDeploy == null) ?
        new BooleanNode(false) : new BooleanNode(builder.restartOnDeploy);
    restartOnInternalRedeploy = (builder.restartOnInternalRedeploy == null) ?
        new RestartOnInternalRedeploy(RestartOnInternalRedeploy.never) : new RestartOnInternalRedeploy(builder.restartOnInternalRedeploy);
    shutdown = new Shutdown(builder.shutdown, throwIfUninitialized);
  }

  /**
   * @return qr.filedistributor
   */
  public Filedistributor filedistributor() {
    return filedistributor;
  }

  /**
   * @return qr.rpc
   */
  public Rpc rpc() {
    return rpc;
  }

  /**
   * @return qr.discriminator
   */
  public String discriminator() {
    return discriminator.value();
  }

  /**
   * @return qr.clustername
   */
  public String clustername() {
    return clustername.value();
  }

  /**
   * @return qr.nodeIndex
   */
  public int nodeIndex() {
    return nodeIndex.value();
  }

  /**
   * @return qr.restartOnDeploy
   */
  public boolean restartOnDeploy() {
    return restartOnDeploy.value();
  }

  /**
   * @return qr.restartOnInternalRedeploy
   */
  public RestartOnInternalRedeploy.Enum restartOnInternalRedeploy() {
    return restartOnInternalRedeploy.value();
  }

  /**
   * @return qr.shutdown
   */
  public Shutdown shutdown() {
    return shutdown;
  }

  private ChangesRequiringRestart getChangesRequiringRestart(QrConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("qr");
      changes.compare(this.discriminator, newConfig.discriminator, "discriminator", "A unique identifier string for this QRS. The only guarantee given is\nthis string will be unique for every QRS in a Vespa application.");
      changes.compare(this.restartOnDeploy, newConfig.restartOnDeploy, "restartOnDeploy", "Force restart of container on deploy, and defer any changes until restart");
      changes.compare(this.restartOnInternalRedeploy, newConfig.restartOnInternalRedeploy, "restartOnInternalRedeploy", "Specifies under what circumstances restart on deploy should apply to internal redeployments");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents qr.filedistributor
   */
  public final static class Filedistributor extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private String configid = null;

      public Builder() { }

      public Builder(Filedistributor config) {
        configid(config.configid());
      }

      private Builder override(Builder __superior) {
        if (__superior.configid != null)
          configid(__superior.configid);
        return this;
      }

      public Builder configid(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        configid = __value;
        return this;
      }


      public Filedistributor build() {
        return new Filedistributor(this);
      }

    }

    // Changes to this config requires restart because it is used to initialize
    // connection to the config system
    // filedistributor rpc configuration
    // TODO: Unused, remove in Vespa 9
    private final ReferenceNode configid;

    public Filedistributor(Builder builder) {
      this(builder, true);
    }

    private Filedistributor(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr.filedistributor must be initialized: " + builder.__uninitialized);

      configid = (builder.configid == null) ?
          new ReferenceNode("") : new ReferenceNode(builder.configid);
    }

    /**
     * @return qr.filedistributor.configid
     */
    public String configid() {
      return configid.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Filedistributor newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("filedistributor");
      return changes;
    }
  }

  /**
   * This class represents qr.rpc
   */
  public final static class Rpc extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean enabled = null;
      private Integer port = null;
      private String host = null;
      private String slobrokId = null;

      public Builder() { }

      public Builder(Rpc config) {
        enabled(config.enabled());
        port(config.port());
        host(config.host());
        slobrokId(config.slobrokId());
      }

      private Builder override(Builder __superior) {
        if (__superior.enabled != null)
          enabled(__superior.enabled);
        if (__superior.port != null)
          port(__superior.port);
        if (__superior.host != null)
          host(__superior.host);
        if (__superior.slobrokId != null)
          slobrokId(__superior.slobrokId);
        return this;
      }

      public Builder enabled(boolean __value) {
        enabled = __value;
        return this;
      }

      private Builder enabled(String __value) {
        return enabled(Boolean.valueOf(__value));
      }

      public Builder port(int __value) {
        port = __value;
        return this;
      }

      private Builder port(String __value) {
        return port(Integer.valueOf(__value));
      }

      public Builder host(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        host = __value;
        return this;
      }


      public Builder slobrokId(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        slobrokId = __value;
        return this;
      }


      public Rpc build() {
        return new Rpc(this);
      }

    }

    // Is RPC server enabled?
    private final BooleanNode enabled;
    // RPC server listen port
    private final IntegerNode port;
    // Which interface to bind to.
    private final StringNode host;
    // The id this service should register itself with in slobrok
    private final StringNode slobrokId;

    public Rpc(Builder builder) {
      this(builder, true);
    }

    private Rpc(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr.rpc must be initialized: " + builder.__uninitialized);

      enabled = (builder.enabled == null) ?
          new BooleanNode(false) : new BooleanNode(builder.enabled);
      port = (builder.port == null) ?
          new IntegerNode(8086) : new IntegerNode(builder.port);
      host = (builder.host == null) ?
          new StringNode("") : new StringNode(builder.host);
      slobrokId = (builder.slobrokId == null) ?
          new StringNode("") : new StringNode(builder.slobrokId);
    }

    /**
     * @return qr.rpc.enabled
     */
    public boolean enabled() {
      return enabled.value();
    }

    /**
     * @return qr.rpc.port
     */
    public int port() {
      return port.value();
    }

    /**
     * @return qr.rpc.host
     */
    public String host() {
      return host.value();
    }

    /**
     * @return qr.rpc.slobrokId
     */
    public String slobrokId() {
      return slobrokId.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Rpc newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("rpc");
      return changes;
    }
  }

  /**
   * This class represents qr.restartOnInternalRedeploy
   * 
   * Specifies under what circumstances restart on deploy should apply to internal redeployments
   */
  public final static class RestartOnInternalRedeploy extends EnumNode<RestartOnInternalRedeploy.Enum> {

    public RestartOnInternalRedeploy(){
      this.value = null;
    }

    public RestartOnInternalRedeploy(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {always, node_changes, content_changes, never}
    public final static Enum always = Enum.always;
    public final static Enum node_changes = Enum.node_changes;
    public final static Enum content_changes = Enum.content_changes;
    public final static Enum never = Enum.never;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

  /**
   * This class represents qr.shutdown
   */
  public final static class Shutdown extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean dumpHeapOnTimeout = null;
      private Double timeout = null;

      public Builder() { }

      public Builder(Shutdown config) {
        dumpHeapOnTimeout(config.dumpHeapOnTimeout());
        timeout(config.timeout());
      }

      private Builder override(Builder __superior) {
        if (__superior.dumpHeapOnTimeout != null)
          dumpHeapOnTimeout(__superior.dumpHeapOnTimeout);
        if (__superior.timeout != null)
          timeout(__superior.timeout);
        return this;
      }

      public Builder dumpHeapOnTimeout(boolean __value) {
        dumpHeapOnTimeout = __value;
        return this;
      }

      private Builder dumpHeapOnTimeout(String __value) {
        return dumpHeapOnTimeout(Boolean.valueOf(__value));
      }

      public Builder timeout(double __value) {
        timeout = __value;
        return this;
      }

      private Builder timeout(String __value) {
        return timeout(Double.valueOf(__value));
      }

      public Shutdown build() {
        return new Shutdown(this);
      }

    }

    // Force heapdump if process is not able to stop within shutdown.timeout
    private final BooleanNode dumpHeapOnTimeout;
    // Timeout for clean shutdown
    private final DoubleNode timeout;

    public Shutdown(Builder builder) {
      this(builder, true);
    }

    private Shutdown(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "qr.shutdown must be initialized: " + builder.__uninitialized);

      dumpHeapOnTimeout = (builder.dumpHeapOnTimeout == null) ?
          new BooleanNode(false) : new BooleanNode(builder.dumpHeapOnTimeout);
      timeout = (builder.timeout == null) ?
          new DoubleNode(50.0D) : new DoubleNode(builder.timeout);
    }

    /**
     * @return qr.shutdown.dumpHeapOnTimeout
     */
    public boolean dumpHeapOnTimeout() {
      return dumpHeapOnTimeout.value();
    }

    /**
     * @return qr.shutdown.timeout
     */
    public double timeout() {
      return timeout.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Shutdown newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("shutdown");
      return changes;
    }
  }

}
