/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.http2.server.internal.HTTP2ServerConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.internal.HttpConnection;

public class RequestUtils {
    public static final String JDISC_REQUEST_X509CERT = "jdisc.request.X509Certificate";
    public static final String JDISC_REQUEST_SSLSESSION = "jdisc.request.SSLSession";
    public static final String JDISC_REQUEST_CHAIN = "jdisc.request.chain";
    public static final String JDISC_RESPONSE_CHAIN = "jdisc.response.chain";
    public static final String JDICS_REQUEST_PORT = "jdisc.request.port";
    static final Set<String> SUPPORTED_METHODS = Stream.of(HttpRequest.Method.OPTIONS, HttpRequest.Method.GET, HttpRequest.Method.HEAD, HttpRequest.Method.POST, HttpRequest.Method.PUT, HttpRequest.Method.DELETE, HttpRequest.Method.TRACE, HttpRequest.Method.PATCH).map(Enum::name).collect(Collectors.toSet());

    private RequestUtils() {
    }

    public static Connection getConnection(Request request) {
        return request.getConnectionMetaData().getConnection();
    }

    public static JDiscServerConnector getConnector(Request request) {
        return (JDiscServerConnector)request.getConnectionMetaData().getConnector();
    }

    static boolean isHttpServerConnection(Connection connection) {
        return connection instanceof HttpConnection || connection instanceof HTTP2ServerConnection;
    }

    public static int getConnectorLocalPort(Request request) {
        JDiscServerConnector connector = RequestUtils.getConnector(request);
        int actualLocalPort = connector.getLocalPort();
        int localPortIfConnectorUnopened = -1;
        int localPortIfConnectorClosed = -2;
        if (actualLocalPort == localPortIfConnectorUnopened || actualLocalPort == localPortIfConnectorClosed) {
            int localPortEphemeralPort;
            int configuredLocalPort = connector.listenPort();
            if (configuredLocalPort == (localPortEphemeralPort = 0)) {
                throw new IllegalStateException("Unable to determine connector's listen port");
            }
            return configuredLocalPort;
        }
        return actualLocalPort;
    }
}

