/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.request;

public class ErrorMessage
implements Cloneable {
    private final int code;
    private final String message;
    private final String detailedMessage;
    private final Throwable cause;

    public ErrorMessage(String message) {
        this(0, message, null, null);
    }

    public ErrorMessage(int code, String message) {
        this(code, message, null, null);
    }

    public ErrorMessage(String message, String details) {
        this(0, message, details, null);
    }

    public ErrorMessage(int code, String message, String details) {
        this(code, message, details, null);
    }

    public ErrorMessage(String message, Throwable cause) {
        this(0, message, null, cause);
    }

    public ErrorMessage(int code, String message, Throwable cause) {
        this(code, message, null, cause);
    }

    public ErrorMessage(String message, String details, Throwable cause) {
        this(0, message, details, cause);
    }

    public ErrorMessage(int code, String message, String details, Throwable cause) {
        if (message == null) {
            throw new NullPointerException("Message cannot be null");
        }
        this.code = code;
        this.message = message;
        this.detailedMessage = details;
        this.cause = cause;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        if (this.code == 0 && this.detailedMessage == null && this.cause == null) {
            return this.message;
        }
        StringBuilder b = new StringBuilder();
        if (this.code != 0) {
            b.append(this.code).append(": ");
        }
        b.append(this.message);
        if (this.detailedMessage != null) {
            b.append(": ").append(this.detailedMessage);
        }
        if (this.cause != null) {
            this.append(this.cause, b);
        }
        return b.toString();
    }

    private void append(Throwable t, StringBuilder b) {
        String lastMessage = null;
        while (t != null) {
            String message = ErrorMessage.getMessage(t);
            if (!(message == null || lastMessage != null && lastMessage.equals(message))) {
                if (!b.isEmpty()) {
                    b.append(": ");
                }
                b.append(message);
            }
            t = t.getCause();
            lastMessage = message;
        }
    }

    private static String getMessage(Throwable t) {
        String message = t.getMessage();
        if (t.getCause() == null) {
            if (message == null) {
                return t.getClass().getSimpleName();
            }
        } else {
            if (message == null) {
                return null;
            }
            if (message.equals(t.getCause().getClass().getName() + ": " + t.getCause().getMessage())) {
                return null;
            }
        }
        return message;
    }

    public int hashCode() {
        return this.code * 7 + this.message.hashCode() + (this.detailedMessage == null ? 0 : 17 * this.detailedMessage.hashCode());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ErrorMessage)) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)o;
        if (this.code != other.code) {
            return false;
        }
        if (!this.message.equals(other.message)) {
            return false;
        }
        if (this.detailedMessage == null) {
            return other.detailedMessage == null;
        }
        if (other.detailedMessage == null) {
            return false;
        }
        return this.detailedMessage.equals(other.detailedMessage);
    }

    public ErrorMessage clone() {
        try {
            return (ErrorMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error");
        }
    }
}

