/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core;

import ai.vespa.metrics.ContainerMetrics;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.jdisc.application.UriPattern;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class HandlerMetricContextUtil {
    private final ConcurrentHashMap<MetricContextKey, Metric.Context> metricContexts = new ConcurrentHashMap();
    private final Metric metric;
    private final String handlerClassName;

    public HandlerMetricContextUtil(Metric metric, String handlerClassName) {
        this.metric = metric;
        this.handlerClassName = handlerClassName;
    }

    public void onHandle(Request request) {
        this.metric.add(ContainerMetrics.HANDLED_REQUESTS.baseName(), (Number)1, this.contextFor(request));
    }

    public void onHandled(Request request) {
        this.metric.set(ContainerMetrics.HANDLED_LATENCY.baseName(), (Number)request.timeElapsed(TimeUnit.MILLISECONDS), this.contextFor(request));
    }

    public void onUnhandledException(Request request) {
        this.metric.add(ContainerMetrics.JDISC_HTTP_HANDLER_UNHANDLED_EXCEPTIONS.baseName(), (Number)1, this.contextFor(request));
    }

    private Metric.Context contextFor(Request request) {
        return this.metricContexts.computeIfAbsent(new MetricContextKey(HandlerMetricContextUtil.handlerBinding(request).orElse(null), this.handlerClassName, request.headers().containsKey((Object)"Host") ? (String)request.headers().get((Object)"Host").get(0) : null, request.getUri().getPort()), key -> {
            HashMap<String, String> dimensions = new HashMap<String, String>();
            if (key.handlerBinding != null) {
                dimensions.put("handler", key.handlerBinding);
            }
            dimensions.put("handler-name", key.handlerClassName);
            if (key.endpoint != null) {
                dimensions.put("endpoint", key.endpoint);
            }
            dimensions.put("port", String.valueOf(key.port));
            return this.metric.createContext(dimensions);
        });
    }

    private static Optional<String> handlerBinding(Request request) {
        BindingMatch match = request.getBindingMatch();
        if (match == null) {
            return Optional.empty();
        }
        UriPattern matched = match.matched();
        if (matched == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(matched.toString());
    }

    private record MetricContextKey(String handlerBinding, String handlerClassName, String endpoint, int port) {
    }
}

