/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.MetricDefinitions;
import com.yahoo.jdisc.http.server.jetty.ResponseMetricAggregator;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

class ServerMetricReporter {
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory("jdisc-jetty-metric-reporter-"));
    private final Metric metric;
    private final Server jetty;
    private final StatisticsHandler statisticsHandler;
    private final ResponseMetricAggregator responseMetricAggregator;

    ServerMetricReporter(Metric metric, Server jetty, StatisticsHandler statisticsHandler, ResponseMetricAggregator responseMetricAggregator) {
        this.metric = metric;
        this.jetty = jetty;
        this.statisticsHandler = statisticsHandler;
        this.responseMetricAggregator = responseMetricAggregator;
    }

    void start() {
        this.executor.scheduleAtFixedRate(new ReporterTask(), 0L, 2L, TimeUnit.SECONDS);
    }

    void shutdown() {
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class ReporterTask
    implements Runnable {
        private final Instant timeStarted = Instant.now();

        private ReporterTask() {
        }

        @Override
        public void run() {
            this.setServerMetrics(ServerMetricReporter.this.responseMetricAggregator);
            ServerMetricReporter.this.statisticsHandler.reset();
            for (Connector connector : ServerMetricReporter.this.jetty.getConnectors()) {
                this.setConnectorMetrics((JDiscServerConnector)connector);
            }
            this.setJettyThreadpoolMetrics();
        }

        private void setServerMetrics(ResponseMetricAggregator statisticsCollector) {
            long timeSinceStarted = System.currentTimeMillis() - this.timeStarted.toEpochMilli();
            ServerMetricReporter.this.metric.set(MetricDefinitions.STARTED_MILLIS, (Number)timeSinceStarted, null);
            this.addResponseMetrics(statisticsCollector);
        }

        private void addResponseMetrics(ResponseMetricAggregator statisticsCollector) {
            statisticsCollector.reportSnapshot(ServerMetricReporter.this.metric);
        }

        private void setJettyThreadpoolMetrics() {
            QueuedThreadPool threadpool = (QueuedThreadPool)ServerMetricReporter.this.jetty.getThreadPool();
            ServerMetricReporter.this.metric.set(MetricDefinitions.JETTY_THREADPOOL_MAX_THREADS, (Number)threadpool.getMaxThreads(), null);
            ServerMetricReporter.this.metric.set(MetricDefinitions.JETTY_THREADPOOL_MIN_THREADS, (Number)threadpool.getMinThreads(), null);
            ServerMetricReporter.this.metric.set(MetricDefinitions.JETTY_THREADPOOL_RESERVED_THREADS, (Number)threadpool.getReservedThreads(), null);
            ServerMetricReporter.this.metric.set(MetricDefinitions.JETTY_THREADPOOL_BUSY_THREADS, (Number)threadpool.getBusyThreads(), null);
            ServerMetricReporter.this.metric.set(MetricDefinitions.JETTY_THREADPOOL_IDLE_THREADS, (Number)threadpool.getIdleThreads(), null);
            ServerMetricReporter.this.metric.set(MetricDefinitions.JETTY_THREADPOOL_TOTAL_THREADS, (Number)threadpool.getThreads(), null);
            ServerMetricReporter.this.metric.set(MetricDefinitions.JETTY_THREADPOOL_QUEUE_SIZE, (Number)threadpool.getQueueSize(), null);
        }

        private void setConnectorMetrics(JDiscServerConnector connector) {
            ConnectionStatistics statistics = connector.getStatistics();
            ServerMetricReporter.this.metric.set(MetricDefinitions.NUM_CONNECTIONS, (Number)statistics.getConnectionsTotal(), connector.getConnectorMetricContext());
            ServerMetricReporter.this.metric.set(MetricDefinitions.NUM_OPEN_CONNECTIONS, (Number)statistics.getConnections(), connector.getConnectorMetricContext());
            ServerMetricReporter.this.metric.set(MetricDefinitions.NUM_CONNECTIONS_OPEN_MAX, (Number)statistics.getConnectionsMax(), connector.getConnectorMetricContext());
            ServerMetricReporter.this.metric.set(MetricDefinitions.CONNECTION_DURATION_MAX, (Number)statistics.getConnectionDurationMax(), connector.getConnectorMetricContext());
            ServerMetricReporter.this.metric.set(MetricDefinitions.CONNECTION_DURATION_MEAN, (Number)statistics.getConnectionDurationMean(), connector.getConnectorMetricContext());
            ServerMetricReporter.this.metric.set(MetricDefinitions.CONNECTION_DURATION_STD_DEV, (Number)statistics.getConnectionDurationStdDev(), connector.getConnectorMetricContext());
        }
    }
}

