/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;

public class ErrorResponse
extends SlimeJsonResponse {
    public ErrorResponse(int statusCode, String errorType, String message) {
        super(statusCode, ErrorResponse.asSlimeMessage(errorType, message));
    }

    private static Slime asSlimeMessage(String errorType, String message) {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setString("error-code", errorType);
        root.setString("message", message);
        return slime;
    }

    public static ErrorResponse notFoundError(String message) {
        return new ErrorResponse(404, errorCodes.NOT_FOUND.name(), message);
    }

    public static ErrorResponse internalServerError(String message) {
        return new ErrorResponse(500, errorCodes.INTERNAL_SERVER_ERROR.name(), message);
    }

    public static ErrorResponse gatewayTimeout(String message) {
        return new ErrorResponse(504, errorCodes.GATEWAY_TIMEOUT.name(), message);
    }

    public static ErrorResponse badRequest(String message) {
        return new ErrorResponse(400, errorCodes.BAD_REQUEST.name(), message);
    }

    public static ErrorResponse forbidden(String message) {
        return new ErrorResponse(403, errorCodes.FORBIDDEN.name(), message);
    }

    public static ErrorResponse unauthorized(String message) {
        return new ErrorResponse(401, errorCodes.UNAUTHORIZED.name(), message);
    }

    public static ErrorResponse methodNotAllowed(String message) {
        return new ErrorResponse(405, errorCodes.METHOD_NOT_ALLOWED.name(), message);
    }

    public static ErrorResponse conflict(String message) {
        return new ErrorResponse(409, errorCodes.CONFLICT.name(), message);
    }

    public static enum errorCodes {
        NOT_FOUND,
        BAD_REQUEST,
        FORBIDDEN,
        METHOD_NOT_ALLOWED,
        INTERNAL_SERVER_ERROR,
        GATEWAY_TIMEOUT,
        UNAUTHORIZED,
        CONFLICT;

    }
}

