/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain.model;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Phase;
import com.yahoo.component.chain.dependencies.Dependencies;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.component.chain.model.ChainsModel;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.core.ChainsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ChainsModelBuilder {
    public static ChainsModel buildFromConfig(ChainsConfig chainsConfig) {
        ChainsModel model = ChainsModelBuilder.createChainsModel(chainsConfig);
        for (ChainsConfig.Components component : chainsConfig.components()) {
            ChainedComponentModel componentModel = ChainsModelBuilder.createChainedComponentModel(component);
            model.register(componentModel.getComponentId(), componentModel);
        }
        return model;
    }

    private static ChainedComponentModel createChainedComponentModel(ChainsConfig.Components component) {
        return new ChainedComponentModel(new BundleInstantiationSpecification(new ComponentSpecification(component.id()), null, null), ChainsModelBuilder.createDependencies(component.dependencies().provides(), component.dependencies().before(), component.dependencies().after()), null);
    }

    private static ChainsModel createChainsModel(ChainsConfig chainsConfig) {
        ChainsModel model = new ChainsModel();
        for (ChainsConfig.Chains chainConfig : chainsConfig.chains()) {
            model.register(ChainsModelBuilder.createChainSpecification(chainConfig));
        }
        return model;
    }

    private static ChainSpecification createChainSpecification(ChainsConfig.Chains config) {
        return new ChainSpecification(new ComponentId(config.id()), ChainsModelBuilder.createInheritance(config.inherits(), config.excludes()), ChainsModelBuilder.createPhases(config.phases()), ChainsModelBuilder.createComponentSpecifications(config.components()));
    }

    private static Collection<Phase> createPhases(List<ChainsConfig.Chains.Phases> phases) {
        ArrayList<Phase> result = new ArrayList<Phase>();
        for (ChainsConfig.Chains.Phases phase : phases) {
            result.add(new Phase(phase.id(), ChainsModelBuilder.createDependencies(null, phase.before(), phase.after())));
        }
        return result;
    }

    private static Dependencies createDependencies(List<String> provides, List<String> before, List<String> after) {
        return new Dependencies(provides, before, after);
    }

    private static Set<ComponentSpecification> createComponentSpecifications(List<String> stringSpecs) {
        LinkedHashSet<ComponentSpecification> specifications = new LinkedHashSet<ComponentSpecification>();
        for (String stringSpec : stringSpecs) {
            specifications.add(new ComponentSpecification(stringSpec));
        }
        return specifications;
    }

    private static ChainSpecification.Inheritance createInheritance(List<String> inherit, List<String> exclude) {
        return new ChainSpecification.Inheritance(ChainsModelBuilder.createComponentSpecifications(inherit), ChainsModelBuilder.createComponentSpecifications(exclude));
    }
}

