/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.response;

import com.yahoo.collections.Tuple2;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import com.yahoo.processing.response.IncomingData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class DefaultIncomingData<DATATYPE extends Data>
implements IncomingData<DATATYPE> {
    private DataList<DATATYPE> owner = null;
    private final CompletableFuture<DataList<DATATYPE>> completionFuture;
    private final List<DATATYPE> dataList = new ArrayList<DATATYPE>();
    private List<Tuple2<Runnable, Executor>> newDataListeners = null;
    private boolean complete = false;

    public DefaultIncomingData() {
        this(null);
    }

    public DefaultIncomingData(DataList<DATATYPE> owner) {
        this.assignOwner(owner);
        this.completionFuture = new CompletableFuture();
    }

    public final void assignOwner(DataList<DATATYPE> owner) {
        if (this.owner != null) {
            throw new NullPointerException("Owner of " + this + " was already assigned");
        }
        this.owner = owner;
    }

    @Override
    public DataList<DATATYPE> getOwner() {
        return this.owner;
    }

    @Override
    public CompletableFuture<DataList<DATATYPE>> completedFuture() {
        return this.completionFuture;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.complete;
    }

    @Override
    public synchronized void addLast(DATATYPE data) {
        this.addLast(List.of(data));
    }

    @Override
    public synchronized void add(DATATYPE data) {
        this.add(List.of(data));
    }

    @Override
    public synchronized void addLast(List<DATATYPE> data) {
        this.add(data);
        this.markComplete();
    }

    @Override
    public synchronized void add(List<DATATYPE> data) {
        if (this.complete) {
            throw new IllegalStateException("Attempted to add data to completed " + this);
        }
        this.dataList.addAll(data);
        this.notifyDataListeners();
    }

    @Override
    public synchronized void markComplete() {
        this.complete = true;
        this.completionFuture.complete(this.owner);
    }

    @Override
    public synchronized List<DATATYPE> drain() {
        ArrayList<DATATYPE> dataListCopy = new ArrayList<DATATYPE>(this.dataList);
        this.dataList.clear();
        return dataListCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNewDataListener(Runnable listener, Executor executor) {
        DefaultIncomingData defaultIncomingData = this;
        synchronized (defaultIncomingData) {
            if (this.newDataListeners == null) {
                this.newDataListeners = new ArrayList<Tuple2<Runnable, Executor>>();
            }
            this.newDataListeners.add((Tuple2<Runnable, Executor>)new Tuple2((Object)listener, (Object)executor));
            if (this.dataList.isEmpty()) {
                return;
            }
        }
        this.notifyDataListeners();
    }

    private void notifyDataListeners() {
        if (this.newDataListeners == null) {
            return;
        }
        for (Tuple2<Runnable, Executor> listener : this.newDataListeners) {
            ((Executor)listener.second).execute((Runnable)listener.first);
        }
    }

    public String toString() {
        return "incoming: " + (this.complete ? "complete" : "incomplete") + ", data " + this.dataList;
    }
}

