/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

public class ExceptionWrapper
extends RuntimeException {
    private final String message;
    private static final long serialVersionUID = 1L;

    public ExceptionWrapper(Throwable t) {
        super(t);
        this.message = ExceptionWrapper.formatMessage(t);
    }

    private static String formatMessage(Throwable t) {
        StringBuilder b = new StringBuilder();
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            StackTraceElement[] trace = cause.getStackTrace();
            String currentMsg = cause.getMessage();
            if (b.length() > 0) {
                b.append(": ");
            }
            b.append(t.getClass().getSimpleName()).append('(');
            if (currentMsg != null) {
                b.append('\"').append(currentMsg).append('\"');
            }
            b.append(')');
            if (trace.length <= 0) continue;
            b.append(" at ").append(trace[0].getClassName()).append('(');
            if (trace[0].getFileName() != null) {
                b.append(trace[0].getFileName()).append(':').append(trace[0].getLineNumber());
            }
            b.append(')');
        }
        return b.toString();
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

