/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter.chain;

import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.jdisc.application.ResourcePool;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.chain.EmptyRequestFilter;
import com.yahoo.jdisc.http.filter.chain.ResponseHandlerGuard;
import java.util.ArrayList;
import java.util.List;

public final class RequestFilterChain
extends AbstractResource
implements RequestFilter {
    private final List<RequestFilter> filters = new ArrayList<RequestFilter>();
    private final ResourcePool filterReferences = new ResourcePool();

    private RequestFilterChain(Iterable<? extends RequestFilter> filters) {
        for (RequestFilter requestFilter : filters) {
            this.filters.add(requestFilter);
            this.filterReferences.retain((SharedResource)requestFilter);
        }
    }

    @Override
    public void filter(HttpRequest request, ResponseHandler responseHandler) {
        ResponseHandlerGuard guard = new ResponseHandlerGuard(responseHandler);
        int len = this.filters.size();
        for (int i = 0; i < len && !guard.isDone(); ++i) {
            this.filters.get(i).filter(request, guard);
        }
    }

    protected void destroy() {
        this.filterReferences.release();
    }

    public static RequestFilter newInstance(RequestFilter ... filters) {
        return RequestFilterChain.newInstance(List.of(filters));
    }

    public static RequestFilter newInstance(List<? extends RequestFilter> filters) {
        if (filters.size() == 0) {
            return EmptyRequestFilter.INSTANCE;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return new RequestFilterChain(filters);
    }
}

