/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.yahoo.api.annotations.Beta;
import com.yahoo.metrics.simple.Point;
import com.yahoo.metrics.simple.Value;
import java.util.ArrayList;
import java.util.Collections;

@Beta
public final class PointBuilder {
    private ArrayList<String> dimensions;
    private ArrayList<Value> location;

    PointBuilder() {
        this(null);
    }

    PointBuilder(Point p) {
        if (p != null) {
            int size = p.dimensionality();
            this.dimensions = new ArrayList(size + 2);
            this.location = new ArrayList(size + 2);
            Collections.addAll(this.dimensions, p.getDimensions());
            Collections.addAll(this.location, p.getLocation());
        } else {
            this.dimensions = new ArrayList(4);
            this.location = new ArrayList(4);
        }
    }

    public PointBuilder set(String dimensionName, long dimensionValue) {
        return this.set(dimensionName, Value.of(dimensionValue));
    }

    public PointBuilder set(String dimensionName, double dimensionValue) {
        return this.set(dimensionName, Value.of(dimensionValue));
    }

    public PointBuilder set(String dimensionName, String dimensionValue) {
        return this.set(dimensionName, Value.of(dimensionValue));
    }

    private PointBuilder set(String axisName, Value w) {
        int i = Collections.binarySearch(this.dimensions, axisName);
        if (i < 0) {
            this.dimensions.add(~i, axisName);
            this.location.add(~i, w);
        } else {
            this.location.set(i, w);
        }
        return this;
    }

    public Point build() {
        Point p = Point.emptyPoint();
        int size = this.dimensions.size();
        if (size != 0) {
            p = new Point(this.dimensions.toArray(new String[size]), this.location.toArray(new Value[size]));
        }
        this.dimensions = null;
        this.location = null;
        return p;
    }

    public String toString() {
        int maxLen = 3;
        StringBuilder builder = new StringBuilder();
        builder.append("PointBuilder [dimensions=").append(this.dimensions != null ? this.dimensions.subList(0, Math.min(this.dimensions.size(), 3)) : null).append(", location=").append(this.location != null ? this.location.subList(0, Math.min(this.location.size(), 3)) : null).append("]");
        return builder.toString();
    }

    public static enum Discriminator {
        LONG,
        DOUBLE,
        STRING;

    }
}

