/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.client;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public final class HttpClientConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "0fc0ad6c1c0aef320f61b73edd7c4740";
    public static final String CONFIG_DEF_NAME = "http-client";
    public static final String CONFIG_DEF_NAMESPACE = "jdisc.http.client";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=jdisc.http.client", "userAgent string default = \"JDisc/1.0\"", "chunkedEncodingEnabled bool default = false", "compressionEnabled bool default = false", "connectionPoolEnabled bool default = true", "followRedirects bool default = false", "removeQueryParamsOnRedirect bool default = true", "sslConnectionPoolEnabled bool default = true", "proxyServer string default = \"\"", "useProxyProperties bool default = false", "useRawUri bool default = false", "compressionLevel int default = -1", "maxNumConnections int default = -1", "maxNumConnectionsPerHost int default = -1", "maxNumRedirects int default = 5", "maxNumRetries int default = 0", "connectionTimeout double default = 60", "idleConnectionInPoolTimeout double default = 60", "idleConnectionTimeout double default = 60", "idleWebSocketTimeout double default = 15", "requestTimeout double default = 60", "ssl.enabled bool default = false", "ssl.keyStoreType string default = \"JKS\"", "ssl.keyStorePath string default = \"jdisc_container/keyStore.jks\"", "ssl.trustStorePath string default = \"conf/jdisc_container/trustStore.jks\"", "ssl.keyDBKey string default = \"jdisc_container\"", "ssl.algorithm string default = \"SunX509\"", "ssl.protocol string default = \"TLS\""};
    private final StringNode userAgent;
    private final BooleanNode chunkedEncodingEnabled;
    private final BooleanNode compressionEnabled;
    private final BooleanNode connectionPoolEnabled;
    private final BooleanNode followRedirects;
    private final BooleanNode removeQueryParamsOnRedirect;
    private final BooleanNode sslConnectionPoolEnabled;
    private final StringNode proxyServer;
    private final BooleanNode useProxyProperties;
    private final BooleanNode useRawUri;
    private final IntegerNode compressionLevel;
    private final IntegerNode maxNumConnections;
    private final IntegerNode maxNumConnectionsPerHost;
    private final IntegerNode maxNumRedirects;
    private final IntegerNode maxNumRetries;
    private final DoubleNode connectionTimeout;
    private final DoubleNode idleConnectionInPoolTimeout;
    private final DoubleNode idleConnectionTimeout;
    private final DoubleNode idleWebSocketTimeout;
    private final DoubleNode requestTimeout;
    private final Ssl ssl;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public HttpClientConfig(Builder builder) {
        this(builder, true);
    }

    private HttpClientConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for http-client must be initialized: " + builder.__uninitialized);
        }
        this.userAgent = builder.userAgent == null ? new StringNode("JDisc/1.0") : new StringNode(builder.userAgent);
        this.chunkedEncodingEnabled = builder.chunkedEncodingEnabled == null ? new BooleanNode(false) : new BooleanNode(builder.chunkedEncodingEnabled.booleanValue());
        this.compressionEnabled = builder.compressionEnabled == null ? new BooleanNode(false) : new BooleanNode(builder.compressionEnabled.booleanValue());
        this.connectionPoolEnabled = builder.connectionPoolEnabled == null ? new BooleanNode(true) : new BooleanNode(builder.connectionPoolEnabled.booleanValue());
        this.followRedirects = builder.followRedirects == null ? new BooleanNode(false) : new BooleanNode(builder.followRedirects.booleanValue());
        this.removeQueryParamsOnRedirect = builder.removeQueryParamsOnRedirect == null ? new BooleanNode(true) : new BooleanNode(builder.removeQueryParamsOnRedirect.booleanValue());
        this.sslConnectionPoolEnabled = builder.sslConnectionPoolEnabled == null ? new BooleanNode(true) : new BooleanNode(builder.sslConnectionPoolEnabled.booleanValue());
        this.proxyServer = builder.proxyServer == null ? new StringNode("") : new StringNode(builder.proxyServer);
        this.useProxyProperties = builder.useProxyProperties == null ? new BooleanNode(false) : new BooleanNode(builder.useProxyProperties.booleanValue());
        this.useRawUri = builder.useRawUri == null ? new BooleanNode(false) : new BooleanNode(builder.useRawUri.booleanValue());
        this.compressionLevel = builder.compressionLevel == null ? new IntegerNode(-1) : new IntegerNode(builder.compressionLevel.intValue());
        this.maxNumConnections = builder.maxNumConnections == null ? new IntegerNode(-1) : new IntegerNode(builder.maxNumConnections.intValue());
        this.maxNumConnectionsPerHost = builder.maxNumConnectionsPerHost == null ? new IntegerNode(-1) : new IntegerNode(builder.maxNumConnectionsPerHost.intValue());
        this.maxNumRedirects = builder.maxNumRedirects == null ? new IntegerNode(5) : new IntegerNode(builder.maxNumRedirects.intValue());
        this.maxNumRetries = builder.maxNumRetries == null ? new IntegerNode(0) : new IntegerNode(builder.maxNumRetries.intValue());
        this.connectionTimeout = builder.connectionTimeout == null ? new DoubleNode(60.0) : new DoubleNode(builder.connectionTimeout.doubleValue());
        this.idleConnectionInPoolTimeout = builder.idleConnectionInPoolTimeout == null ? new DoubleNode(60.0) : new DoubleNode(builder.idleConnectionInPoolTimeout.doubleValue());
        this.idleConnectionTimeout = builder.idleConnectionTimeout == null ? new DoubleNode(60.0) : new DoubleNode(builder.idleConnectionTimeout.doubleValue());
        this.idleWebSocketTimeout = builder.idleWebSocketTimeout == null ? new DoubleNode(15.0) : new DoubleNode(builder.idleWebSocketTimeout.doubleValue());
        this.requestTimeout = builder.requestTimeout == null ? new DoubleNode(60.0) : new DoubleNode(builder.requestTimeout.doubleValue());
        this.ssl = new Ssl(builder.ssl, throwIfUninitialized);
    }

    public String userAgent() {
        return this.userAgent.value();
    }

    public boolean chunkedEncodingEnabled() {
        return this.chunkedEncodingEnabled.value();
    }

    public boolean compressionEnabled() {
        return this.compressionEnabled.value();
    }

    public boolean connectionPoolEnabled() {
        return this.connectionPoolEnabled.value();
    }

    public boolean followRedirects() {
        return this.followRedirects.value();
    }

    public boolean removeQueryParamsOnRedirect() {
        return this.removeQueryParamsOnRedirect.value();
    }

    public boolean sslConnectionPoolEnabled() {
        return this.sslConnectionPoolEnabled.value();
    }

    public String proxyServer() {
        return this.proxyServer.value();
    }

    public boolean useProxyProperties() {
        return this.useProxyProperties.value();
    }

    public boolean useRawUri() {
        return this.useRawUri.value();
    }

    public int compressionLevel() {
        return this.compressionLevel.value();
    }

    public int maxNumConnections() {
        return this.maxNumConnections.value();
    }

    public int maxNumConnectionsPerHost() {
        return this.maxNumConnectionsPerHost.value();
    }

    public int maxNumRedirects() {
        return this.maxNumRedirects.value();
    }

    public int maxNumRetries() {
        return this.maxNumRetries.value();
    }

    public double connectionTimeout() {
        return this.connectionTimeout.value();
    }

    public double idleConnectionInPoolTimeout() {
        return this.idleConnectionInPoolTimeout.value();
    }

    public double idleConnectionTimeout() {
        return this.idleConnectionTimeout.value();
    }

    public double idleWebSocketTimeout() {
        return this.idleWebSocketTimeout.value();
    }

    public double requestTimeout() {
        return this.requestTimeout.value();
    }

    public Ssl ssl() {
        return this.ssl;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(HttpClientConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String userAgent = null;
        private Boolean chunkedEncodingEnabled = null;
        private Boolean compressionEnabled = null;
        private Boolean connectionPoolEnabled = null;
        private Boolean followRedirects = null;
        private Boolean removeQueryParamsOnRedirect = null;
        private Boolean sslConnectionPoolEnabled = null;
        private String proxyServer = null;
        private Boolean useProxyProperties = null;
        private Boolean useRawUri = null;
        private Integer compressionLevel = null;
        private Integer maxNumConnections = null;
        private Integer maxNumConnectionsPerHost = null;
        private Integer maxNumRedirects = null;
        private Integer maxNumRetries = null;
        private Double connectionTimeout = null;
        private Double idleConnectionInPoolTimeout = null;
        private Double idleConnectionTimeout = null;
        private Double idleWebSocketTimeout = null;
        private Double requestTimeout = null;
        public Ssl.Builder ssl = new Ssl.Builder();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(HttpClientConfig config) {
            this.userAgent(config.userAgent());
            this.chunkedEncodingEnabled(config.chunkedEncodingEnabled());
            this.compressionEnabled(config.compressionEnabled());
            this.connectionPoolEnabled(config.connectionPoolEnabled());
            this.followRedirects(config.followRedirects());
            this.removeQueryParamsOnRedirect(config.removeQueryParamsOnRedirect());
            this.sslConnectionPoolEnabled(config.sslConnectionPoolEnabled());
            this.proxyServer(config.proxyServer());
            this.useProxyProperties(config.useProxyProperties());
            this.useRawUri(config.useRawUri());
            this.compressionLevel(config.compressionLevel());
            this.maxNumConnections(config.maxNumConnections());
            this.maxNumConnectionsPerHost(config.maxNumConnectionsPerHost());
            this.maxNumRedirects(config.maxNumRedirects());
            this.maxNumRetries(config.maxNumRetries());
            this.connectionTimeout(config.connectionTimeout());
            this.idleConnectionInPoolTimeout(config.idleConnectionInPoolTimeout());
            this.idleConnectionTimeout(config.idleConnectionTimeout());
            this.idleWebSocketTimeout(config.idleWebSocketTimeout());
            this.requestTimeout(config.requestTimeout());
            this.ssl(new Ssl.Builder(config.ssl()));
        }

        private Builder override(Builder __superior) {
            if (__superior.userAgent != null) {
                this.userAgent(__superior.userAgent);
            }
            if (__superior.chunkedEncodingEnabled != null) {
                this.chunkedEncodingEnabled(__superior.chunkedEncodingEnabled);
            }
            if (__superior.compressionEnabled != null) {
                this.compressionEnabled(__superior.compressionEnabled);
            }
            if (__superior.connectionPoolEnabled != null) {
                this.connectionPoolEnabled(__superior.connectionPoolEnabled);
            }
            if (__superior.followRedirects != null) {
                this.followRedirects(__superior.followRedirects);
            }
            if (__superior.removeQueryParamsOnRedirect != null) {
                this.removeQueryParamsOnRedirect(__superior.removeQueryParamsOnRedirect);
            }
            if (__superior.sslConnectionPoolEnabled != null) {
                this.sslConnectionPoolEnabled(__superior.sslConnectionPoolEnabled);
            }
            if (__superior.proxyServer != null) {
                this.proxyServer(__superior.proxyServer);
            }
            if (__superior.useProxyProperties != null) {
                this.useProxyProperties(__superior.useProxyProperties);
            }
            if (__superior.useRawUri != null) {
                this.useRawUri(__superior.useRawUri);
            }
            if (__superior.compressionLevel != null) {
                this.compressionLevel(__superior.compressionLevel);
            }
            if (__superior.maxNumConnections != null) {
                this.maxNumConnections(__superior.maxNumConnections);
            }
            if (__superior.maxNumConnectionsPerHost != null) {
                this.maxNumConnectionsPerHost(__superior.maxNumConnectionsPerHost);
            }
            if (__superior.maxNumRedirects != null) {
                this.maxNumRedirects(__superior.maxNumRedirects);
            }
            if (__superior.maxNumRetries != null) {
                this.maxNumRetries(__superior.maxNumRetries);
            }
            if (__superior.connectionTimeout != null) {
                this.connectionTimeout(__superior.connectionTimeout);
            }
            if (__superior.idleConnectionInPoolTimeout != null) {
                this.idleConnectionInPoolTimeout(__superior.idleConnectionInPoolTimeout);
            }
            if (__superior.idleConnectionTimeout != null) {
                this.idleConnectionTimeout(__superior.idleConnectionTimeout);
            }
            if (__superior.idleWebSocketTimeout != null) {
                this.idleWebSocketTimeout(__superior.idleWebSocketTimeout);
            }
            if (__superior.requestTimeout != null) {
                this.requestTimeout(__superior.requestTimeout);
            }
            this.ssl(this.ssl.override(__superior.ssl));
            return this;
        }

        public Builder userAgent(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.userAgent = __value;
            return this;
        }

        public Builder chunkedEncodingEnabled(boolean __value) {
            this.chunkedEncodingEnabled = __value;
            return this;
        }

        private Builder chunkedEncodingEnabled(String __value) {
            return this.chunkedEncodingEnabled(Boolean.valueOf(__value));
        }

        public Builder compressionEnabled(boolean __value) {
            this.compressionEnabled = __value;
            return this;
        }

        private Builder compressionEnabled(String __value) {
            return this.compressionEnabled(Boolean.valueOf(__value));
        }

        public Builder connectionPoolEnabled(boolean __value) {
            this.connectionPoolEnabled = __value;
            return this;
        }

        private Builder connectionPoolEnabled(String __value) {
            return this.connectionPoolEnabled(Boolean.valueOf(__value));
        }

        public Builder followRedirects(boolean __value) {
            this.followRedirects = __value;
            return this;
        }

        private Builder followRedirects(String __value) {
            return this.followRedirects(Boolean.valueOf(__value));
        }

        public Builder removeQueryParamsOnRedirect(boolean __value) {
            this.removeQueryParamsOnRedirect = __value;
            return this;
        }

        private Builder removeQueryParamsOnRedirect(String __value) {
            return this.removeQueryParamsOnRedirect(Boolean.valueOf(__value));
        }

        public Builder sslConnectionPoolEnabled(boolean __value) {
            this.sslConnectionPoolEnabled = __value;
            return this;
        }

        private Builder sslConnectionPoolEnabled(String __value) {
            return this.sslConnectionPoolEnabled(Boolean.valueOf(__value));
        }

        public Builder proxyServer(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.proxyServer = __value;
            return this;
        }

        public Builder useProxyProperties(boolean __value) {
            this.useProxyProperties = __value;
            return this;
        }

        private Builder useProxyProperties(String __value) {
            return this.useProxyProperties(Boolean.valueOf(__value));
        }

        public Builder useRawUri(boolean __value) {
            this.useRawUri = __value;
            return this;
        }

        private Builder useRawUri(String __value) {
            return this.useRawUri(Boolean.valueOf(__value));
        }

        public Builder compressionLevel(int __value) {
            this.compressionLevel = __value;
            return this;
        }

        private Builder compressionLevel(String __value) {
            return this.compressionLevel(Integer.valueOf(__value));
        }

        public Builder maxNumConnections(int __value) {
            this.maxNumConnections = __value;
            return this;
        }

        private Builder maxNumConnections(String __value) {
            return this.maxNumConnections(Integer.valueOf(__value));
        }

        public Builder maxNumConnectionsPerHost(int __value) {
            this.maxNumConnectionsPerHost = __value;
            return this;
        }

        private Builder maxNumConnectionsPerHost(String __value) {
            return this.maxNumConnectionsPerHost(Integer.valueOf(__value));
        }

        public Builder maxNumRedirects(int __value) {
            this.maxNumRedirects = __value;
            return this;
        }

        private Builder maxNumRedirects(String __value) {
            return this.maxNumRedirects(Integer.valueOf(__value));
        }

        public Builder maxNumRetries(int __value) {
            this.maxNumRetries = __value;
            return this;
        }

        private Builder maxNumRetries(String __value) {
            return this.maxNumRetries(Integer.valueOf(__value));
        }

        public Builder connectionTimeout(double __value) {
            this.connectionTimeout = __value;
            return this;
        }

        private Builder connectionTimeout(String __value) {
            return this.connectionTimeout(Double.valueOf(__value));
        }

        public Builder idleConnectionInPoolTimeout(double __value) {
            this.idleConnectionInPoolTimeout = __value;
            return this;
        }

        private Builder idleConnectionInPoolTimeout(String __value) {
            return this.idleConnectionInPoolTimeout(Double.valueOf(__value));
        }

        public Builder idleConnectionTimeout(double __value) {
            this.idleConnectionTimeout = __value;
            return this;
        }

        private Builder idleConnectionTimeout(String __value) {
            return this.idleConnectionTimeout(Double.valueOf(__value));
        }

        public Builder idleWebSocketTimeout(double __value) {
            this.idleWebSocketTimeout = __value;
            return this;
        }

        private Builder idleWebSocketTimeout(String __value) {
            return this.idleWebSocketTimeout(Double.valueOf(__value));
        }

        public Builder requestTimeout(double __value) {
            this.requestTimeout = __value;
            return this;
        }

        private Builder requestTimeout(String __value) {
            return this.requestTimeout(Double.valueOf(__value));
        }

        public Builder ssl(Ssl.Builder __builder) {
            this.ssl = __builder;
            return this;
        }

        public Builder ssl(Consumer<Ssl.Builder> __func) {
            Ssl.Builder __inner = new Ssl.Builder();
            __func.accept(__inner);
            this.ssl = __inner;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return HttpClientConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return HttpClientConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return HttpClientConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this);
        }
    }

    public static final class Ssl
    extends InnerNode {
        private final BooleanNode enabled;
        private final StringNode keyStoreType;
        private final StringNode keyStorePath;
        private final StringNode trustStorePath;
        private final StringNode keyDBKey;
        private final StringNode algorithm;
        private final StringNode protocol;

        public Ssl(Builder builder) {
            this(builder, true);
        }

        private Ssl(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for http-client.ssl must be initialized: " + builder.__uninitialized);
            }
            this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
            this.keyStoreType = builder.keyStoreType == null ? new StringNode("JKS") : new StringNode(builder.keyStoreType);
            this.keyStorePath = builder.keyStorePath == null ? new StringNode("jdisc_container/keyStore.jks") : new StringNode(builder.keyStorePath);
            this.trustStorePath = builder.trustStorePath == null ? new StringNode("conf/jdisc_container/trustStore.jks") : new StringNode(builder.trustStorePath);
            this.keyDBKey = builder.keyDBKey == null ? new StringNode("jdisc_container") : new StringNode(builder.keyDBKey);
            this.algorithm = builder.algorithm == null ? new StringNode("SunX509") : new StringNode(builder.algorithm);
            this.protocol = builder.protocol == null ? new StringNode("TLS") : new StringNode(builder.protocol);
        }

        public boolean enabled() {
            return this.enabled.value();
        }

        public String keyStoreType() {
            return this.keyStoreType.value();
        }

        public String keyStorePath() {
            return this.keyStorePath.value();
        }

        public String trustStorePath() {
            return this.trustStorePath.value();
        }

        public String keyDBKey() {
            return this.keyDBKey.value();
        }

        public String algorithm() {
            return this.algorithm.value();
        }

        public String protocol() {
            return this.protocol.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Ssl newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("ssl");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean enabled = null;
            private String keyStoreType = null;
            private String keyStorePath = null;
            private String trustStorePath = null;
            private String keyDBKey = null;
            private String algorithm = null;
            private String protocol = null;

            public Builder() {
            }

            public Builder(Ssl config) {
                this.enabled(config.enabled());
                this.keyStoreType(config.keyStoreType());
                this.keyStorePath(config.keyStorePath());
                this.trustStorePath(config.trustStorePath());
                this.keyDBKey(config.keyDBKey());
                this.algorithm(config.algorithm());
                this.protocol(config.protocol());
            }

            private Builder override(Builder __superior) {
                if (__superior.enabled != null) {
                    this.enabled(__superior.enabled);
                }
                if (__superior.keyStoreType != null) {
                    this.keyStoreType(__superior.keyStoreType);
                }
                if (__superior.keyStorePath != null) {
                    this.keyStorePath(__superior.keyStorePath);
                }
                if (__superior.trustStorePath != null) {
                    this.trustStorePath(__superior.trustStorePath);
                }
                if (__superior.keyDBKey != null) {
                    this.keyDBKey(__superior.keyDBKey);
                }
                if (__superior.algorithm != null) {
                    this.algorithm(__superior.algorithm);
                }
                if (__superior.protocol != null) {
                    this.protocol(__superior.protocol);
                }
                return this;
            }

            public Builder enabled(boolean __value) {
                this.enabled = __value;
                return this;
            }

            private Builder enabled(String __value) {
                return this.enabled(Boolean.valueOf(__value));
            }

            public Builder keyStoreType(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.keyStoreType = __value;
                return this;
            }

            public Builder keyStorePath(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.keyStorePath = __value;
                return this;
            }

            public Builder trustStorePath(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.trustStorePath = __value;
                return this;
            }

            public Builder keyDBKey(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.keyDBKey = __value;
                return this;
            }

            public Builder algorithm(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.algorithm = __value;
                return this;
            }

            public Builder protocol(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.protocol = __value;
                return this;
            }

            public Ssl build() {
                return new Ssl(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

