/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.threadpool;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class ContainerThreadpoolConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "da0bba9306ffe8d51489e1f8ceb3568e";
    public static final String CONFIG_DEF_NAME = "container-threadpool";
    public static final String CONFIG_DEF_NAMESPACE = "container.handler.threadpool";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.handler.threadpool", "maxThreads int default=0", "minThreads int default=0", "keepAliveTime double default=5.0", "queueSize int default=0", "maxThreadExecutionTimeSeconds int default=190", "name string default=\"default-pool\""};
    private final IntegerNode maxThreads;
    private final IntegerNode minThreads;
    private final DoubleNode keepAliveTime;
    private final IntegerNode queueSize;
    private final IntegerNode maxThreadExecutionTimeSeconds;
    private final StringNode name;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public ContainerThreadpoolConfig(Builder builder) {
        this(builder, true);
    }

    private ContainerThreadpoolConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for container-threadpool must be initialized: " + builder.__uninitialized);
        }
        this.maxThreads = builder.maxThreads == null ? new IntegerNode(0) : new IntegerNode(builder.maxThreads.intValue());
        this.minThreads = builder.minThreads == null ? new IntegerNode(0) : new IntegerNode(builder.minThreads.intValue());
        this.keepAliveTime = builder.keepAliveTime == null ? new DoubleNode(5.0) : new DoubleNode(builder.keepAliveTime.doubleValue());
        this.queueSize = builder.queueSize == null ? new IntegerNode(0) : new IntegerNode(builder.queueSize.intValue());
        this.maxThreadExecutionTimeSeconds = builder.maxThreadExecutionTimeSeconds == null ? new IntegerNode(190) : new IntegerNode(builder.maxThreadExecutionTimeSeconds.intValue());
        this.name = builder.name == null ? new StringNode("default-pool") : new StringNode(builder.name);
    }

    public int maxThreads() {
        return this.maxThreads.value();
    }

    public int minThreads() {
        return this.minThreads.value();
    }

    public double keepAliveTime() {
        return this.keepAliveTime.value();
    }

    public int queueSize() {
        return this.queueSize.value();
    }

    public int maxThreadExecutionTimeSeconds() {
        return this.maxThreadExecutionTimeSeconds.value();
    }

    public String name() {
        return this.name.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ContainerThreadpoolConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer maxThreads = null;
        private Integer minThreads = null;
        private Double keepAliveTime = null;
        private Integer queueSize = null;
        private Integer maxThreadExecutionTimeSeconds = null;
        private String name = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ContainerThreadpoolConfig config) {
            this.maxThreads(config.maxThreads());
            this.minThreads(config.minThreads());
            this.keepAliveTime(config.keepAliveTime());
            this.queueSize(config.queueSize());
            this.maxThreadExecutionTimeSeconds(config.maxThreadExecutionTimeSeconds());
            this.name(config.name());
        }

        private Builder override(Builder __superior) {
            if (__superior.maxThreads != null) {
                this.maxThreads(__superior.maxThreads);
            }
            if (__superior.minThreads != null) {
                this.minThreads(__superior.minThreads);
            }
            if (__superior.keepAliveTime != null) {
                this.keepAliveTime(__superior.keepAliveTime);
            }
            if (__superior.queueSize != null) {
                this.queueSize(__superior.queueSize);
            }
            if (__superior.maxThreadExecutionTimeSeconds != null) {
                this.maxThreadExecutionTimeSeconds(__superior.maxThreadExecutionTimeSeconds);
            }
            if (__superior.name != null) {
                this.name(__superior.name);
            }
            return this;
        }

        public Builder maxThreads(int __value) {
            this.maxThreads = __value;
            return this;
        }

        private Builder maxThreads(String __value) {
            return this.maxThreads(Integer.valueOf(__value));
        }

        public Builder minThreads(int __value) {
            this.minThreads = __value;
            return this;
        }

        private Builder minThreads(String __value) {
            return this.minThreads(Integer.valueOf(__value));
        }

        public Builder keepAliveTime(double __value) {
            this.keepAliveTime = __value;
            return this;
        }

        private Builder keepAliveTime(String __value) {
            return this.keepAliveTime(Double.valueOf(__value));
        }

        public Builder queueSize(int __value) {
            this.queueSize = __value;
            return this;
        }

        private Builder queueSize(String __value) {
            return this.queueSize(Integer.valueOf(__value));
        }

        public Builder maxThreadExecutionTimeSeconds(int __value) {
            this.maxThreadExecutionTimeSeconds = __value;
            return this;
        }

        private Builder maxThreadExecutionTimeSeconds(String __value) {
            return this.maxThreadExecutionTimeSeconds(Integer.valueOf(__value));
        }

        public Builder name(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.name = __value;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ContainerThreadpoolConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ContainerThreadpoolConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ContainerThreadpoolConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ContainerThreadpoolConfig build() {
            return new ContainerThreadpoolConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

