/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.response;

import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.request.ErrorMessage;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FutureResponse
implements Future<Response> {
    private final Request request;
    private final FutureTask<Response> task;
    private final Execution execution;
    private static final Logger log = Logger.getLogger(FutureResponse.class.getName());

    public FutureResponse(Callable<Response> callable, Execution execution, Request request) {
        this.task = new FutureTask<Response>(callable);
        this.request = request;
        this.execution = execution;
    }

    public FutureTask<Response> delegate() {
        return this.task;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.task.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.task.isDone();
    }

    @Override
    public Response get() {
        try {
            return this.task.get();
        }
        catch (InterruptedException e) {
            return new Response(this.request, new ErrorMessage("'" + this.execution + "' was interrupted", e));
        }
        catch (ExecutionException e) {
            log.log(Level.WARNING, "Exception on executing " + this.execution + " for " + this.request, e);
            return new Response(this.request, new ErrorMessage("Error in '" + this.execution + "'", e));
        }
    }

    @Override
    public Response get(long timeout, TimeUnit timeunit) {
        try {
            return this.task.get(timeout, timeunit);
        }
        catch (InterruptedException e) {
            return new Response(this.request, new ErrorMessage("'" + this.execution + "' was interrupted", e));
        }
        catch (ExecutionException e) {
            log.log(Level.WARNING, "Exception on executing " + this.execution + " for " + this.request, e);
            return new Response(this.request, new ErrorMessage("Error in '" + this.execution + "'", e));
        }
        catch (TimeoutException e) {
            return new Response(this.request, new ErrorMessage("Error executing '" + this.execution + "':  Chain timed out."));
        }
    }

    public Request getRequest() {
        return this.request;
    }
}

