/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.handler.CompletionHandler;
import java.util.List;

public class CompletionHandlers {
    public static void tryComplete(CompletionHandler handler) {
        if (handler == null) {
            return;
        }
        try {
            handler.completed();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void tryFail(CompletionHandler handler, Throwable t) {
        if (handler == null) {
            return;
        }
        try {
            handler.failed(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static CompletionHandler wrap(CompletionHandler ... handlers) {
        return CompletionHandlers.wrap(List.of(handlers));
    }

    public static CompletionHandler wrap(final Iterable<CompletionHandler> handlers) {
        return new CompletionHandler(){

            public void completed() {
                for (CompletionHandler handler : handlers) {
                    CompletionHandlers.tryComplete(handler);
                }
            }

            public void failed(Throwable t) {
                for (CompletionHandler handler : handlers) {
                    CompletionHandlers.tryFail(handler, t);
                }
            }
        };
    }
}

