/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain.model;

import com.google.common.collect.ImmutableSet;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Phase;
import com.yahoo.component.chain.model.Resolver;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ChainSpecification {
    public final ComponentId componentId;
    public final Inheritance inheritance;
    private final Map<String, Phase> phases;
    public final Set<ComponentSpecification> componentReferences;

    public ChainSpecification(ComponentId componentId, Inheritance inheritance, Collection<Phase> phases, Set<ComponentSpecification> componentReferences) {
        ChainSpecification.assertNotNull(componentId, inheritance, phases, componentReferences);
        if (ChainSpecification.componentsByName(componentReferences).size() != componentReferences.size()) {
            throw new RuntimeException("Two components with the same name are specified in '" + componentId + "', but name must be unique inside a given chain.");
        }
        this.componentId = componentId;
        this.inheritance = inheritance;
        this.phases = ChainSpecification.copyPhasesImmutable(phases);
        this.componentReferences = ImmutableSet.copyOf(ChainSpecification.filterByComponentSpecification(componentReferences, inheritance.excludedComponents));
    }

    public ChainSpecification addComponents(Collection<ComponentSpecification> componentSpecifications) {
        LinkedHashSet<ComponentSpecification> newComponentReferences = new LinkedHashSet<ComponentSpecification>(this.componentReferences);
        newComponentReferences.addAll(componentSpecifications);
        return new ChainSpecification(this.componentId, this.inheritance, this.phases(), newComponentReferences);
    }

    public ChainSpecification addInherits(Collection<ComponentSpecification> inheritedChains) {
        return new ChainSpecification(this.componentId, this.inheritance.addInherits(inheritedChains), this.phases(), this.componentReferences);
    }

    public ChainSpecification setComponentId(ComponentId newComponentId) {
        return new ChainSpecification(newComponentId, this.inheritance, this.phases(), this.componentReferences);
    }

    public ChainSpecification flatten(Resolver<ChainSpecification> allChainSpecifications) {
        ArrayDeque<ComponentId> path = new ArrayDeque<ComponentId>();
        return this.flatten(allChainSpecifications, path);
    }

    private ChainSpecification flatten(Resolver<ChainSpecification> allChainSpecifications, Deque<ComponentId> path) {
        path.push(this.componentId);
        Map<String, ComponentSpecification> resultingComponents = ChainSpecification.componentsByName(this.componentReferences);
        LinkedHashMap<String, Phase> resultingPhases = new LinkedHashMap<String, Phase>(this.phases);
        for (ComponentSpecification inheritedChainSpecification : this.inheritance.chainSpecifications) {
            ChainSpecification inheritedChain = this.resolveChain(path, allChainSpecifications, inheritedChainSpecification).flatten(allChainSpecifications, path);
            ChainSpecification.mergeInto(resultingComponents, ChainSpecification.filterByComponentSpecification(ChainSpecification.filterByName(inheritedChain.componentReferences, ChainSpecification.names(this.componentReferences)), this.inheritance.excludedComponents));
            ChainSpecification.mergeInto(resultingPhases, inheritedChain.phases);
        }
        path.pop();
        return new ChainSpecification(this.componentId, this.inheritance.flattened(), resultingPhases.values(), new LinkedHashSet<ComponentSpecification>(resultingComponents.values()));
    }

    public Collection<Phase> phases() {
        return this.phases.values();
    }

    private static <T> Set<T> immutableCopy(Set<T> set) {
        if (set == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(set);
    }

    private static Map<String, Phase> copyPhasesImmutable(Collection<Phase> phases) {
        LinkedHashMap<String, Phase> result = new LinkedHashMap<String, Phase>();
        for (Phase phase : phases) {
            Phase oldValue = result.put(phase.getName(), phase);
            if (oldValue == null) continue;
            throw new RuntimeException("Two phases with the same name " + phase.getName() + " present in the same scope.");
        }
        return Collections.unmodifiableMap(result);
    }

    private static void assertNotNull(Object ... objects) {
        for (Object o : objects) {
            assert (o != null);
        }
    }

    static Map<String, ComponentSpecification> componentsByName(Set<ComponentSpecification> componentSpecifications) {
        LinkedHashMap<String, ComponentSpecification> componentsByName = new LinkedHashMap<String, ComponentSpecification>();
        for (ComponentSpecification component : componentSpecifications) {
            componentsByName.put(component.getName(), component);
        }
        return componentsByName;
    }

    private static void mergeInto(Map<String, ComponentSpecification> resultingComponents, Set<ComponentSpecification> components) {
        for (ComponentSpecification component : components) {
            String name = component.getName();
            if (resultingComponents.containsKey(name)) {
                resultingComponents.put(name, component.intersect(resultingComponents.get(name)));
                continue;
            }
            resultingComponents.put(name, component);
        }
    }

    private static void mergeInto(Map<String, Phase> resultingPhases, Map<String, Phase> phases) {
        for (Phase phase : phases.values()) {
            String name = phase.getName();
            if (resultingPhases.containsKey(name)) {
                phase = phase.union(resultingPhases.get(name));
            }
            resultingPhases.put(name, phase);
        }
    }

    private static Set<String> names(Set<ComponentSpecification> components) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (ComponentSpecification component : components) {
            names.add(component.getName());
        }
        return names;
    }

    private static Set<ComponentSpecification> filterByComponentSpecification(Set<ComponentSpecification> components, Set<ComponentSpecification> excludes) {
        LinkedHashSet<ComponentSpecification> result = new LinkedHashSet<ComponentSpecification>();
        for (ComponentSpecification component : components) {
            if (ChainSpecification.matches(component, excludes)) continue;
            result.add(component);
        }
        return result;
    }

    private static Set<ComponentSpecification> filterByName(Set<ComponentSpecification> components, Set<String> names) {
        LinkedHashSet<ComponentSpecification> result = new LinkedHashSet<ComponentSpecification>();
        for (ComponentSpecification component : components) {
            if (names.contains(component.getName())) continue;
            result.add(component);
        }
        return result;
    }

    private static boolean matches(ComponentSpecification component, Set<ComponentSpecification> excludes) {
        ComponentId id = component.toId().withoutNamespace();
        for (ComponentSpecification exclude : excludes) {
            if (!exclude.matches(id)) continue;
            return true;
        }
        return false;
    }

    private ChainSpecification resolveChain(Deque<ComponentId> path, Resolver<ChainSpecification> allChainSpecifications, ComponentSpecification chainSpecification) {
        ChainSpecification chain = allChainSpecifications.resolve(chainSpecification);
        if (chain == null) {
            throw new RuntimeException("Missing chain '" + chainSpecification + "'.");
        }
        if (path.contains(chain.componentId)) {
            throw new RuntimeException("The chain " + chain.componentId + " inherits(possibly indirectly) from itself.");
        }
        return chain;
    }

    public static class Inheritance {
        public final Set<ComponentSpecification> chainSpecifications;
        public final Set<ComponentSpecification> excludedComponents;

        Inheritance flattened() {
            return new Inheritance(Set.of(), this.excludedComponents);
        }

        public Inheritance(Set<ComponentSpecification> inheritedChains, Set<ComponentSpecification> excludedComponents) {
            this.chainSpecifications = ChainSpecification.immutableCopy(inheritedChains);
            this.excludedComponents = ChainSpecification.immutableCopy(excludedComponents);
        }

        public Inheritance addInherits(Collection<ComponentSpecification> inheritedChains) {
            LinkedHashSet<ComponentSpecification> newChainSpecifications = new LinkedHashSet<ComponentSpecification>(this.chainSpecifications);
            newChainSpecifications.addAll(inheritedChains);
            return new Inheritance(newChainSpecifications, this.excludedComponents);
        }
    }
}

