/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.yahoo.collections.ListMap;
import com.yahoo.container.logging.HitCounts;
import com.yahoo.yolean.trace.TraceNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AccessLogEntry {
    private final Object monitor = new Object();
    private HitCounts hitCounts;
    private TraceNode traceNode;
    private ListMap<String, String> keyValues = null;
    private Content content;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(Content entity) {
        Object object = this.monitor;
        synchronized (object) {
            AccessLogEntry.requireNull(this.content);
            this.content = entity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Content> getContent() {
        Object object = this.monitor;
        synchronized (object) {
            return Optional.ofNullable(this.content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHitCounts(HitCounts hitCounts) {
        Object object = this.monitor;
        synchronized (object) {
            AccessLogEntry.requireNull(this.hitCounts);
            this.hitCounts = hitCounts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HitCounts getHitCounts() {
        Object object = this.monitor;
        synchronized (object) {
            return this.hitCounts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyValue(String key, String value) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.keyValues == null) {
                this.keyValues = new ListMap();
            }
            this.keyValues.put((Object)key, (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getKeyValues() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.keyValues == null) {
                return null;
            }
            Map newMapWithImmutableValues = AccessLogEntry.mapValues(this.keyValues.entrySet(), valueList -> Collections.unmodifiableList(new ArrayList(valueList)));
            return Collections.unmodifiableMap(newMapWithImmutableValues);
        }
    }

    private static <K, V1, V2> Map<K, V2> mapValues(Set<Map.Entry<K, V1>> entrySet, Function<V1, V2> valueConverter) {
        return entrySet.stream().collect(Collectors.toMap(entry -> entry.getKey(), entry -> valueConverter.apply(entry.getValue())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrace(TraceNode traceNode) {
        Object object = this.monitor;
        synchronized (object) {
            AccessLogEntry.requireNull(this.traceNode);
            this.traceNode = traceNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceNode getTrace() {
        Object object = this.monitor;
        synchronized (object) {
            return this.traceNode;
        }
    }

    public String toString() {
        return "AccessLogEntry{hitCounts=" + this.hitCounts + ", traceNode=" + this.traceNode + ", keyValues=" + this.keyValues + "}";
    }

    private static void requireNull(Object value) {
        if (value != null) {
            throw new IllegalStateException("Attempt to overwrite field that has been assigned. Value: " + value);
        }
    }

    public record Content(String type, long length, byte[] body) {
    }
}

