/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain.dependencies.ordering;

import com.yahoo.component.chain.dependencies.ordering.NameProvider;
import com.yahoo.component.chain.dependencies.ordering.Node;
import java.util.HashSet;
import java.util.Map;

public class CycleDependenciesException
extends RuntimeException {
    public Map<String, NameProvider> cycleNodes;

    CycleDependenciesException(Map<String, NameProvider> cycleNodes) {
        super("The following set of dependencies lead to a cycle:\n" + CycleDependenciesException.createDotString(cycleNodes));
        this.cycleNodes = cycleNodes;
    }

    private static String createDotString(Map<String, NameProvider> cycleNodes) {
        StringBuilder res = new StringBuilder();
        res.append("digraph dependencyGraph {\n");
        HashSet<Node> used = new HashSet<Node>();
        for (Node node : cycleNodes.values()) {
            if (node.ready()) continue;
            node.dotDependenciesString(res, used);
        }
        res.append("}");
        return res.toString();
    }

    public String dotString() {
        return CycleDependenciesException.createDotString(this.cycleNodes);
    }
}

