/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.container.jdisc.AclMapping;
import com.yahoo.container.jdisc.RequestView;
import com.yahoo.jdisc.http.HttpRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class HttpMethodAclMapping
implements AclMapping {
    private final Map<HttpRequest.Method, AclMapping.Action> mappings;

    private HttpMethodAclMapping(Map<HttpRequest.Method, AclMapping.Action> overrides) {
        HashMap<HttpRequest.Method, AclMapping.Action> tmp = new HashMap<HttpRequest.Method, AclMapping.Action>(HttpMethodAclMapping.defaultMappings());
        tmp.putAll(overrides);
        this.mappings = Map.copyOf(tmp);
    }

    private static Map<HttpRequest.Method, AclMapping.Action> defaultMappings() {
        return Map.of(HttpRequest.Method.GET, AclMapping.Action.READ, HttpRequest.Method.HEAD, AclMapping.Action.READ, HttpRequest.Method.OPTIONS, AclMapping.Action.READ, HttpRequest.Method.POST, AclMapping.Action.WRITE, HttpRequest.Method.DELETE, AclMapping.Action.WRITE, HttpRequest.Method.PUT, AclMapping.Action.WRITE, HttpRequest.Method.PATCH, AclMapping.Action.WRITE, HttpRequest.Method.CONNECT, AclMapping.Action.WRITE, HttpRequest.Method.TRACE, AclMapping.Action.WRITE);
    }

    @Override
    public AclMapping.Action get(RequestView requestView) {
        return Optional.ofNullable(this.mappings.get((Object)requestView.method())).orElseThrow(() -> new IllegalArgumentException("Illegal request method: " + requestView.method()));
    }

    public static Builder standard() {
        return new Builder();
    }

    public static class Builder {
        private final Map<HttpRequest.Method, AclMapping.Action> overrides = new HashMap<HttpRequest.Method, AclMapping.Action>();

        public Builder override(HttpRequest.Method method, AclMapping.Action action) {
            this.overrides.put(method, action);
            return this;
        }

        public HttpMethodAclMapping build() {
            return new HttpMethodAclMapping(this.overrides);
        }
    }
}

