/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain;

import com.yahoo.component.chain.dependencies.Dependencies;
import java.util.Set;
import java.util.TreeSet;

public class Phase {
    public final Dependencies dependencies;

    public Phase(String name, Set<String> before, Set<String> after) {
        this.dependencies = new Dependencies(this.provides(name), before, after);
    }

    public Phase(String name, Dependencies dependencies) {
        this(name, dependencies.before(), dependencies.after());
        assert (dependencies.provides().isEmpty());
    }

    private Set<String> provides(String name) {
        TreeSet<String> provides = new TreeSet<String>();
        provides.add(name);
        return provides;
    }

    public String getName() {
        return this.dependencies.provides().iterator().next();
    }

    public Set<String> before() {
        return this.dependencies.before();
    }

    public Set<String> after() {
        return this.dependencies.after();
    }

    public Phase union(Phase phase) {
        assert (this.getName().equals(phase.getName()));
        Dependencies union = this.dependencies.union(phase.dependencies);
        return new Phase(this.getName(), union.before(), union.after());
    }
}

