/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.componentgraph.cycle;

import com.yahoo.container.di.componentgraph.cycle.Graph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CycleFinder<T> {
    private static final Logger log = Logger.getLogger(CycleFinder.class.getName());
    private final Graph<T> graph;
    private Map<T, State> colors;
    private List<T> cycle;

    public CycleFinder(Graph<T> graph) {
        this.graph = graph;
    }

    private void resetState() {
        this.cycle = null;
        this.colors = new LinkedHashMap<T, State>();
        this.graph.getVertices().forEach(v -> this.colors.put(v, State.WHITE));
    }

    public List<T> findCycle() {
        this.resetState();
        for (T vertex : this.graph.getVertices()) {
            if (this.colors.get(vertex) != State.WHITE || !this.visitDepthFirst(vertex, new ArrayList<T>(Collections.singletonList(vertex)))) continue;
            if (this.cycle == null) {
                throw new IllegalStateException("Null cycle - this should never happen");
            }
            if (this.cycle.isEmpty()) {
                throw new IllegalStateException("Empty cycle - this should never happen");
            }
            log.log(Level.FINE, () -> "Cycle detected: " + this.cycle);
            return this.cycle;
        }
        return new ArrayList();
    }

    private boolean visitDepthFirst(T vertex, List<T> path) {
        this.colors.put(vertex, State.GRAY);
        log.log(Level.FINE, () -> "Vertex start " + vertex + " - colors: " + this.colors + " - path: " + path);
        for (T adjacent : this.graph.getAdjacent(vertex)) {
            path.add(adjacent);
            if (this.colors.get(adjacent) == State.GRAY) {
                this.cycle = this.removePathIntoCycle(path);
                return true;
            }
            if (this.colors.get(adjacent) == State.WHITE && this.visitDepthFirst(adjacent, path)) {
                return true;
            }
            path.remove(adjacent);
        }
        this.colors.put(vertex, State.BLACK);
        log.log(Level.FINE, () -> "Vertex end " + vertex + " - colors: " + this.colors + " - path: " + path);
        return false;
    }

    private List<T> removePathIntoCycle(List<T> pathWithCycle) {
        Object cycleStart = pathWithCycle.get(pathWithCycle.size() - 1);
        return pathWithCycle.stream().dropWhile(vertex -> !vertex.equals(cycleStart)).toList();
    }

    static enum State {
        WHITE,
        GRAY,
        BLACK;

    }
}

