/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.container.logging.CircularArrayAccessLogKeeper;
import com.yahoo.jdisc.Metric;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.Executor;

public class AccessLogRequestHandler
extends ThreadedHttpRequestHandler {
    private final CircularArrayAccessLogKeeper circularArrayAccessLogKeeper;
    private final JsonFactory jsonFactory = new JsonFactory();

    @Inject
    public AccessLogRequestHandler(Executor executor, Metric metric, CircularArrayAccessLogKeeper circularArrayAccessLogKeeper) {
        super(executor, metric);
        this.circularArrayAccessLogKeeper = circularArrayAccessLogKeeper;
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        final List<String> uris = this.circularArrayAccessLogKeeper.getUris();
        return new HttpResponse(200){

            @Override
            public void render(OutputStream outputStream) throws IOException {
                JsonGenerator generator = AccessLogRequestHandler.this.jsonFactory.createGenerator(outputStream);
                generator.writeStartObject();
                generator.writeArrayFieldStart("entries");
                for (String uri : uris) {
                    generator.writeStartObject();
                    generator.writeStringField("url", uri);
                    generator.writeEndObject();
                }
                generator.writeEndArray();
                generator.writeEndObject();
                generator.close();
            }
        };
    }
}

