/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import com.yahoo.restapi.RestApiException;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.slime.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Json
implements Iterable<Json> {
    private final Inspector inspector;
    private final String path;

    public static Json of(Slime slime) {
        return Json.of((Inspector)slime.get());
    }

    public static Json of(Inspector inspector) {
        return new Json(inspector, "");
    }

    public static Json of(String json) {
        return Json.of(SlimeUtils.jsonToSlime((String)json));
    }

    private Json(Inspector inspector, String path) {
        this.inspector = Objects.requireNonNull(inspector);
        this.path = Objects.requireNonNull(path);
    }

    public Json f(String field) {
        return this.field(field);
    }

    public Json field(String field) {
        this.requireType(Type.OBJECT);
        return new Json(this.inspector.field(field), this.path.isEmpty() ? field : "%s.%s".formatted(this.path, field));
    }

    public Json a(int index) {
        return this.entry(index);
    }

    public Json entry(int index) {
        this.requireType(Type.ARRAY);
        return new Json(this.inspector.entry(index), "%s[%d]".formatted(this.path, index));
    }

    public int length() {
        return this.inspector.children();
    }

    public boolean has(String field) {
        return this.inspector.field(field).valid();
    }

    public boolean isPresent() {
        return this.inspector.valid();
    }

    public boolean isMissing() {
        return !this.isPresent();
    }

    public Optional<String> asOptionalString() {
        return Optional.ofNullable(this.asString(null));
    }

    public String asString() {
        this.requireType(Type.STRING);
        return this.inspector.asString();
    }

    public String asString(String defaultValue) {
        if (this.isMissing()) {
            return defaultValue;
        }
        return this.asString();
    }

    public OptionalLong asOptionalLong() {
        return this.isMissing() ? OptionalLong.empty() : OptionalLong.of(this.asLong());
    }

    public long asLong() {
        this.requireType(Type.LONG, Type.DOUBLE);
        return this.inspector.asLong();
    }

    public long asLong(long defaultValue) {
        if (this.isMissing()) {
            return defaultValue;
        }
        return this.asLong();
    }

    public OptionalDouble asOptionalDouble() {
        return this.isMissing() ? OptionalDouble.empty() : OptionalDouble.of(this.asDouble());
    }

    public double asDouble() {
        this.requireType(Type.LONG, Type.DOUBLE);
        return this.inspector.asDouble();
    }

    public double asDouble(double defaultValue) {
        if (this.isMissing()) {
            return defaultValue;
        }
        return this.asDouble();
    }

    public Optional<Boolean> asOptionalBool() {
        return this.isMissing() ? Optional.empty() : Optional.of(this.asBool());
    }

    public boolean asBool() {
        this.requireType(Type.BOOL);
        return this.inspector.asBool();
    }

    public boolean asBool(boolean defaultValue) {
        if (this.isMissing()) {
            return defaultValue;
        }
        return this.asBool();
    }

    public List<Json> toList() {
        ArrayList list = new ArrayList(this.length());
        this.forEachEntry((Json json) -> list.add(json));
        return List.copyOf(list);
    }

    public Stream<Json> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public String toJson(boolean pretty) {
        return SlimeUtils.toJson((Inspector)this.inspector, (!pretty ? 1 : 0) != 0);
    }

    public boolean isString() {
        return this.inspector.type() == Type.STRING;
    }

    public boolean isArray() {
        return this.inspector.type() == Type.ARRAY;
    }

    public boolean isLong() {
        return this.inspector.type() == Type.LONG;
    }

    public boolean isDouble() {
        return this.inspector.type() == Type.DOUBLE;
    }

    public boolean isBool() {
        return this.inspector.type() == Type.BOOL;
    }

    public boolean isNumber() {
        return this.isLong() || this.isDouble();
    }

    public boolean isObject() {
        return this.inspector.type() == Type.OBJECT;
    }

    @Override
    public Iterator<Json> iterator() {
        this.requireType(Type.ARRAY);
        return new Iterator<Json>(){
            private int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < Json.this.length();
            }

            @Override
            public Json next() {
                return Json.this.entry(this.current++);
            }
        };
    }

    public void forEachField(BiConsumer<String, Json> consumer) {
        this.requireType(Type.OBJECT);
        this.inspector.traverse((name, inspector) -> consumer.accept(name, this.field(name)));
    }

    public void forEachEntry(BiConsumer<Integer, Json> consumer) {
        this.requireType(Type.ARRAY);
        for (int i = 0; i < this.length(); ++i) {
            consumer.accept(i, this.entry(i));
        }
    }

    public void forEachEntry(Consumer<Json> consumer) {
        this.requireType(Type.ARRAY);
        for (int i = 0; i < this.length(); ++i) {
            consumer.accept(this.entry(i));
        }
    }

    private void requireType(Type ... types) {
        this.requirePresent();
        if (!List.of(types).contains(this.inspector.type())) {
            throw this.createInvalidTypeException(types);
        }
    }

    private void requirePresent() {
        if (this.isMissing()) {
            throw this.createMissingMemberException();
        }
    }

    private RestApiException.BadRequest createInvalidTypeException(Type ... expected) {
        String expectedTypesString = Arrays.stream(expected).map(this::toString).collect(Collectors.joining("' or '", "'", "'"));
        String pathString = this.path.isEmpty() ? "JSON" : "JSON member '%s'".formatted(this.path);
        return new RestApiException.BadRequest("Expected %s to be a %s but got '%s'".formatted(pathString, expectedTypesString, this.toString(this.inspector.type())));
    }

    private RestApiException.BadRequest createMissingMemberException() {
        return new RestApiException.BadRequest(this.path.isEmpty() ? "Missing JSON" : "Missing JSON member '%s'".formatted(this.path));
    }

    private String toString(Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.NIX -> "null";
            case Type.BOOL -> "boolean";
            case Type.LONG -> "integer";
            case Type.DOUBLE -> "float";
            case Type.STRING, Type.DATA -> "string";
            case Type.ARRAY -> "array";
            case Type.OBJECT -> "object";
        };
    }

    public String toString() {
        return "Json{inspector=" + this.inspector + ", path='" + this.path + "'}";
    }

    public static class Builder {
        protected final Cursor cursor;

        public static Array newArray() {
            return new Array(new Slime().setArray());
        }

        public static Object newObject() {
            return new Object(new Slime().setObject());
        }

        private Builder(Cursor cursor) {
            this.cursor = cursor;
        }

        public Json build() {
            return Json.of((Inspector)this.cursor);
        }

        public static class Array
        extends Builder {
            private Array(Cursor cursor) {
                super(cursor);
            }

            public Array add(Array array) {
                SlimeUtils.copyArray((Inspector)array.cursor, (Cursor)this.cursor.addArray());
                return this;
            }

            public Array add(Object object) {
                SlimeUtils.copyObject((Inspector)object.cursor, (Cursor)this.cursor.addObject());
                return this;
            }

            public Array add(Json json) {
                SlimeUtils.addValue((Inspector)json.inspector, (Cursor)this.cursor.addObject());
                return this;
            }

            public Array addArray() {
                return new Array(this.cursor.addArray());
            }

            public Object addObject() {
                return new Object(this.cursor.addObject());
            }

            public Array add(String value) {
                this.cursor.addString(value);
                return this;
            }

            public Array add(long value) {
                this.cursor.addLong(value);
                return this;
            }

            public Array add(double value) {
                this.cursor.addDouble(value);
                return this;
            }

            public Array add(boolean value) {
                this.cursor.addBool(value);
                return this;
            }
        }

        public static class Object
        extends Builder {
            private Object(Cursor cursor) {
                super(cursor);
            }

            public Object set(String field, Array array) {
                SlimeUtils.copyArray((Inspector)array.cursor, (Cursor)this.cursor.setArray(field));
                return this;
            }

            public Object set(String field, Object object) {
                SlimeUtils.copyObject((Inspector)object.cursor, (Cursor)this.cursor.setObject(field));
                return this;
            }

            public Object set(String field, Json json) {
                SlimeUtils.setObjectEntry((Inspector)json.inspector, (String)field, (Cursor)this.cursor);
                return this;
            }

            public Array setArray(String field) {
                return new Array(this.cursor.setArray(field));
            }

            public Object setObject(String field) {
                return new Object(this.cursor.setObject(field));
            }

            public Object set(String field, String value) {
                this.cursor.setString(field, value);
                return this;
            }

            public Object set(String field, long value) {
                this.cursor.setLong(field, value);
                return this;
            }

            public Object set(String field, double value) {
                this.cursor.setDouble(field, value);
                return this;
            }

            public Object set(String field, boolean value) {
                this.cursor.setBool(field, value);
                return this;
            }
        }
    }
}

